/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.CacheRuleHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.cache.ICache;
import org.apache.shenyu.plugin.cache.handler.CachePluginDataHandler;
import org.apache.shenyu.plugin.cache.utils.CacheUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.annotation.NonNull;
import reactor.util.function.Tuple2;

public class CachePlugin
extends AbstractShenyuPlugin {
    private final CacheRuleHandle defaultRuleHandle = new CacheRuleHandle();

    public Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ICache cache = CacheUtils.getCache();
        if (Objects.nonNull(cache)) {
            return cache.getData(CacheUtils.dataKey(exchange)).zipWith(cache.getData(CacheUtils.contentTypeKey(exchange))).flatMap(data -> Mono.just(Optional.of(data))).defaultIfEmpty(Optional.empty()).flatMap(dataFlg -> {
                if (dataFlg.isPresent()) {
                    byte[] bytes = (byte[])((Tuple2)dataFlg.get()).getT1();
                    byte[] contentTypeBytes = (byte[])((Tuple2)dataFlg.get()).getT2();
                    cache.setContentType(exchange, contentTypeBytes);
                    return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(bytes)).doOnNext(data -> exchange.getResponse().getHeaders().setContentLength((long)data.readableByteCount())));
                }
                CacheRuleHandle cacheRuleHandle = this.buildRuleHandle(rule);
                return chain.execute(exchange.mutate().response((ServerHttpResponse)new CacheHttpResponse(exchange, cacheRuleHandle)).build());
            });
        }
        CacheRuleHandle cacheRuleHandle = this.buildRuleHandle(rule);
        return chain.execute(exchange.mutate().response((ServerHttpResponse)new CacheHttpResponse(exchange, cacheRuleHandle)).build());
    }

    public int getOrder() {
        return PluginEnum.CACHE.getCode();
    }

    public String named() {
        return PluginEnum.CACHE.getName();
    }

    private CacheRuleHandle buildRuleHandle(RuleData rule) {
        if (StringUtils.isNotEmpty((CharSequence)rule.getId())) {
            return (CacheRuleHandle)CachePluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        }
        return this.defaultRuleHandle;
    }

    static class CacheHttpResponse
    extends ServerHttpResponseDecorator {
        private final ServerWebExchange exchange;
        private final CacheRuleHandle cacheRuleHandle;

        CacheHttpResponse(ServerWebExchange exchange, CacheRuleHandle cacheRuleHandle) {
            super(exchange.getResponse());
            this.exchange = exchange;
            this.cacheRuleHandle = cacheRuleHandle;
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            return super.writeWith(this.cacheResponse(body));
        }

        @NonNull
        private Flux<? extends DataBuffer> cacheResponse(Publisher<? extends DataBuffer> body) {
            ICache cache = CacheUtils.getCache();
            if (Objects.nonNull(cache)) {
                MediaType contentType = this.getHeaders().getContentType();
                return Flux.from(body).doOnNext(buffer -> {
                    cache.cacheData(CacheUtils.dataKey(this.exchange), buffer.asByteBuffer().array(), this.cacheRuleHandle.getTimeoutSeconds().longValue()).subscribeOn(Schedulers.boundedElastic()).subscribe();
                    cache.cacheContentType(CacheUtils.contentTypeKey(this.exchange), contentType, this.cacheRuleHandle.getTimeoutSeconds().longValue());
                });
            }
            return Flux.from(body);
        }
    }
}

