/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.utils;

import java.net.URI;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.cache.ICache;
import org.springframework.web.server.ServerWebExchange;

public final class CacheUtils {
    private static final String CONTENT_TYPEKEY_SUFFIX = "contentType";
    private static final String KEY_JOIN_RULE = "-";

    private CacheUtils() {
    }

    public static String dataKey(ServerWebExchange exchange) {
        URI uri = exchange.getRequest().getURI();
        return DigestUtils.md5Hex((String)String.join((CharSequence)KEY_JOIN_RULE, uri.getQuery(), uri.getPath()));
    }

    public static String contentTypeKey(ServerWebExchange exchange) {
        return String.join((CharSequence)KEY_JOIN_RULE, CacheUtils.dataKey(exchange), CONTENT_TYPEKEY_SUFFIX);
    }

    public static ICache getCache() {
        return (ICache)Singleton.INST.get(ICache.class);
    }
}

