/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.dubbo.common.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.dto.convert.rule.impl.DubboRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.DubboUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;

public abstract class AbstractDubboPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, DubboRuleHandle>> RULE_CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);
    public static final Supplier<CommonHandleCache<String, List<DubboUpstream>>> SELECTOR_CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    protected abstract void initConfigCache(DubboRegisterConfig var1);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            DubboRegisterConfig dubboRegisterConfig = (DubboRegisterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), DubboRegisterConfig.class);
            DubboRegisterConfig exist = (DubboRegisterConfig)Singleton.INST.get(DubboRegisterConfig.class);
            if (Objects.isNull(dubboRegisterConfig)) {
                return;
            }
            if (Objects.isNull(exist) || !dubboRegisterConfig.equals((Object)exist)) {
                this.initConfigCache(dubboRegisterConfig);
            }
            Singleton.INST.single(DubboRegisterConfig.class, (Object)dubboRegisterConfig);
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        List dubboUpstreams = GsonUtils.getInstance().fromList(selectorData.getHandle(), DubboUpstream.class);
        if (CollectionUtils.isEmpty((Collection)dubboUpstreams)) {
            return;
        }
        ArrayList<DubboUpstream> graySelectorHandle = new ArrayList<DubboUpstream>();
        for (DubboUpstream each : dubboUpstreams) {
            if (!StringUtils.isNotBlank((CharSequence)each.getUpstreamUrl()) || !Objects.nonNull(each.isGray()) || !Boolean.TRUE.equals(each.isGray())) continue;
            graySelectorHandle.add(each);
        }
        if (CollectionUtils.isNotEmpty(graySelectorHandle)) {
            SELECTOR_CACHED_HANDLE.get().cachedHandle((Object)selectorData.getId(), graySelectorHandle);
            UpstreamCacheManager.getInstance().submit(selectorData.getId(), this.convertUpstreamList(graySelectorHandle));
        }
    }

    public void removeSelector(SelectorData selectorData) {
        SELECTOR_CACHED_HANDLE.get().removeHandle((Object)selectorData.getId());
        UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
    }

    public void handlerRule(RuleData ruleData) {
        RULE_CACHED_HANDLE.get().cachedHandle((Object)ruleData.getId(), (Object)((DubboRuleHandle)GsonUtils.getInstance().fromJson(ruleData.getHandle(), DubboRuleHandle.class)));
    }

    public void removeRule(RuleData ruleData) {
        RULE_CACHED_HANDLE.get().removeHandle((Object)ruleData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.DUBBO.getName();
    }

    private List<Upstream> convertUpstreamList(List<DubboUpstream> handleList) {
        return handleList.stream().map(u -> Upstream.builder().protocol(u.getProtocol()).url(u.getUpstreamUrl()).weight(u.getWeight()).status(u.isStatus()).timestamp(u.getTimestamp()).warmup(u.getWarmup()).group(u.getGroup()).version(u.getVersion()).build()).collect(Collectors.toList());
    }
}

