/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.cache;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.MapUtils;
import org.apache.shenyu.plugin.grpc.client.GrpcClientBuilder;
import org.apache.shenyu.plugin.grpc.client.ShenyuGrpcClient;

public final class GrpcClientCache {
    private static final Map<String, ShenyuGrpcClient> CLIENT_CACHE = Maps.newConcurrentMap();

    private GrpcClientCache() {
    }

    public static void initGrpcClient(String selectorId) {
        MapUtils.computeIfAbsent(CLIENT_CACHE, (Object)selectorId, s -> GrpcClientBuilder.buildClient(selectorId));
    }

    public static ShenyuGrpcClient getGrpcClient(String selectorId) {
        return CLIENT_CACHE.get(selectorId);
    }

    public static void removeClient(String selectorId) {
        ShenyuGrpcClient grpcClient = CLIENT_CACHE.remove(selectorId);
        if (Objects.nonNull(grpcClient)) {
            grpcClient.close();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Map.Entry<String, ShenyuGrpcClient> entry : CLIENT_CACHE.entrySet()) {
                ShenyuGrpcClient grpcClient = entry.getValue();
                grpcClient.close();
            }
            CLIENT_CACHE.clear();
        }));
    }
}

