/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.handler;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.base.handler.DiscoveryUpstreamDataHandler;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.springframework.util.ObjectUtils;

public class GrpcDiscoveryUpstreamDataHandler
implements DiscoveryUpstreamDataHandler {
    public void handlerDiscoveryUpstreamData(DiscoverySyncData discoverySyncData) {
        if (Objects.isNull(discoverySyncData) || Objects.isNull(discoverySyncData.getSelectorId())) {
            return;
        }
        ApplicationConfigCache.getInstance().handlerUpstream(discoverySyncData.getSelectorId(), this.convertUpstreamList(discoverySyncData.getUpstreamDataList()));
    }

    private List<GrpcUpstream> convertUpstreamList(List<DiscoveryUpstreamData> upstreamList) {
        if (ObjectUtils.isEmpty(upstreamList)) {
            return Collections.emptyList();
        }
        return upstreamList.stream().map(u -> GrpcUpstream.builder().protocol(u.getProtocol()).upstreamUrl(u.getUrl()).weight(u.getWeight()).status(0 == u.getStatus()).timestamp(Optional.ofNullable(u.getDateCreated()).map(Timestamp::getTime).orElse(System.currentTimeMillis()).longValue()).build()).collect(Collectors.toList());
    }

    public String pluginName() {
        return PluginEnum.GRPC.getName();
    }
}

