/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.oauth2;

import java.util.Objects;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class OAuth2Plugin
implements ShenyuPlugin {
    private static final String BEARER = "Bearer ";
    private static final String OAUTH2_ENABLE = "enable";
    private final ReactiveOAuth2AuthorizedClientService authorizedClientService;

    public OAuth2Plugin(ReactiveOAuth2AuthorizedClientService authorizedClientService) {
        this.authorizedClientService = authorizedClientService;
    }

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        Boolean skip = Objects.requireNonNull((Boolean)exchange.getAttribute("skip"));
        return Boolean.TRUE.equals(skip) ? chain.execute(exchange) : exchange.getPrincipal().filter(OAuth2AuthenticationToken.class::isInstance).cast(OAuth2AuthenticationToken.class).flatMap(token -> this.authorizedClientService.loadAuthorizedClient(token.getAuthorizedClientRegistrationId(), token.getName())).flatMap(client -> chain.execute(this.handleToken(exchange, (OAuth2AuthorizedClient)client)));
    }

    public int getOrder() {
        return PluginEnum.OAUTH2.getCode();
    }

    public String named() {
        return PluginEnum.OAUTH2.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        Boolean skipStatus = (Boolean)exchange.getAttribute(OAUTH2_ENABLE);
        return skipStatus == null || skipStatus != false;
    }

    private ServerWebExchange handleToken(ServerWebExchange exchange, OAuth2AuthorizedClient client) {
        ServerHttpRequest.Builder mutate = exchange.getRequest().mutate();
        mutate.header("Authorization", new String[]{BEARER + client.getAccessToken().getTokenValue()});
        return exchange.mutate().request(mutate.build()).build();
    }
}

