/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RPCMessageWriter
implements MessageWriter {
    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            Object result = exchange.getAttribute("rpc_result");
            if (Objects.isNull(result)) {
                Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            Mono responseMono = WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)result);
            exchange.getAttributes().put("RESPONSE_MONO", responseMono);
            Consumer consumer = (Consumer)exchange.getAttribute("WATCHER_HTTP_STATUS");
            Optional.ofNullable(consumer).ifPresent(c -> c.accept(exchange.getResponse().getStatusCode()));
            return responseMono;
        }));
    }

    @Override
    public List<String> supportTypes() {
        return Lists.newArrayList((Object[])new String[]{RpcTypeEnum.DUBBO.getName(), RpcTypeEnum.SOFA.getName(), RpcTypeEnum.GRPC.getName(), RpcTypeEnum.MOTAN.getName(), RpcTypeEnum.TARS.getName(), RpcTypeEnum.BRPC.getName()});
    }
}

