/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientMessageWriter
implements MessageWriter {
    private static final String COMMON_BIN_MEDIA_TYPE_REGEX;
    private static final Set<String> CORS_HEADERS;

    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            String media;
            ServerHttpResponse response = exchange.getResponse();
            ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
            if (Objects.isNull(clientResponse)) {
                Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.SERVICE_RESULT_ERROR);
                return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
            }
            this.redrawResponseHeaders(response, clientResponse);
            if (clientResponse.headers().contentType().isPresent() && (media = ((MediaType)clientResponse.headers().contentType().get()).toString().toLowerCase()).matches(COMMON_BIN_MEDIA_TYPE_REGEX)) {
                return response.writeWith((Publisher)clientResponse.body(BodyExtractors.toDataBuffers())).doOnCancel(() -> this.clean(exchange));
            }
            clientResponse = ResponseUtils.buildClientResponse((ServerHttpResponse)response, (Publisher)((Publisher)clientResponse.body(BodyExtractors.toDataBuffers())));
            Mono responseMono = clientResponse.bodyToMono(byte[].class).flatMap(originData -> WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)originData)).doOnCancel(() -> this.clean(exchange));
            exchange.getAttributes().put("RESPONSE_MONO", responseMono);
            Consumer consumer = (Consumer)exchange.getAttribute("WATCHER_HTTP_STATUS");
            Optional.ofNullable(consumer).ifPresent(c -> c.accept(response.getStatusCode()));
            return responseMono;
        }));
    }

    @Override
    public List<String> supportTypes() {
        return Lists.newArrayList((Object[])new String[]{RpcTypeEnum.HTTP.getName(), RpcTypeEnum.SPRING_CLOUD.getName()});
    }

    private void redrawResponseHeaders(ServerHttpResponse response, ClientResponse clientResponse) {
        response.getCookies().putAll((Map)clientResponse.cookies());
        HttpHeaders httpHeaders = clientResponse.headers().asHttpHeaders();
        if (CORS_HEADERS.stream().anyMatch(arg_0 -> ((HttpHeaders)httpHeaders).containsKey(arg_0))) {
            CORS_HEADERS.forEach(header -> response.getHeaders().remove(header));
        }
        if (httpHeaders.containsKey((Object)"Access-Control-Allow-Origin")) {
            HttpHeaders temp = new HttpHeaders();
            temp.putAll((Map)httpHeaders);
            temp.remove((Object)"Access-Control-Allow-Origin");
            httpHeaders = temp;
        }
        response.getHeaders().putAll((Map)httpHeaders);
    }

    private void clean(ServerWebExchange exchange) {
        ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
        if (Objects.nonNull(clientResponse)) {
            clientResponse.bodyToMono(Void.class).subscribe();
        }
    }

    static {
        CORS_HEADERS = new HashSet<String>(){
            {
                this.add("Access-Control-Allow-Methods");
                this.add("Access-Control-Max-Age");
                this.add("Access-Control-Allow-Headers");
                this.add("Access-Control-Expose-Headers");
            }
        };
        HashSet<String> commonBinaryTypes = new HashSet<String>(){
            {
                this.add("image");
                this.add("audio");
                this.add("video");
                this.add("ogg");
                this.add("zip");
                this.add("rar");
                this.add("word");
                this.add("excel");
                this.add("csv");
                this.add("powerpoint");
                this.add("openxmlformats-officedocument");
                this.add("binary");
                this.add("pdf");
                this.add("octet-stream");
                this.add("force-download");
            }
        };
        StringJoiner regexBuilder = new StringJoiner("|");
        commonBinaryTypes.forEach(t -> regexBuilder.add(String.format(".*%s.*", t)));
        COMMON_BIN_MEDIA_TYPE_REGEX = regexBuilder.toString();
    }
}

