/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.Objects;
import org.apache.shenyu.common.utils.DigestUtils;
import org.apache.shenyu.web.filter.AbstractWebFilter;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.DispatcherHandler;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LocalDispatcherFilter
extends AbstractWebFilter {
    private static final String DISPATCHER_PATH = "/shenyu/";
    private final DispatcherHandler dispatcherHandler;
    private final String sha512Key;

    public LocalDispatcherFilter(DispatcherHandler dispatcherHandler, String sha512Key) {
        this.dispatcherHandler = dispatcherHandler;
        this.sha512Key = sha512Key;
    }

    @Override
    protected Mono<Boolean> doMatcher(ServerWebExchange exchange, WebFilterChain chain) {
        return Mono.just((Object)exchange.getRequest().getURI().getPath().startsWith(DISPATCHER_PATH));
    }

    @Override
    protected Mono<Void> doFilter(ServerWebExchange exchange) {
        String localKey = exchange.getRequest().getHeaders().getFirst("localKey");
        if (Objects.isNull(this.sha512Key) || !this.sha512Key.equalsIgnoreCase(DigestUtils.sha512Hex((String)localKey)) || Objects.isNull(localKey)) {
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.FORBIDDEN, "The key is not correct."));
        }
        return this.dispatcherHandler.handle(exchange);
    }
}

