/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.common.v1;

import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.ProtocolMessageEnum;
import io.envoyproxy.pgv.ComparativeValidation;
import io.envoyproxy.pgv.EnumValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.StringValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.Comparator;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;

public class BanyandbCommonValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbCommon.Metadata.class)) {
            return new MetadataValidator();
        }
        if (clazz.equals(BanyandbCommon.IntervalRule.class)) {
            return new IntervalRuleValidator();
        }
        if (clazz.equals(BanyandbCommon.ResourceOpts.class)) {
            return new ResourceOptsValidator();
        }
        if (clazz.equals(BanyandbCommon.Group.class)) {
            return new GroupValidator();
        }
        return null;
    }

    public static class MetadataValidator
    implements ValidatorImpl<BanyandbCommon.Metadata> {
        public void assertValid(BanyandbCommon.Metadata proto, ValidatorIndex index) throws ValidationException {
            StringValidation.minLength((String)".banyandb.common.v1.Metadata.name", (String)proto.getName(), (int)1);
        }
    }

    public static class IntervalRuleValidator
    implements ValidatorImpl<BanyandbCommon.IntervalRule> {
        private final Integer NUM__GT = 0;

        public void assertValid(BanyandbCommon.IntervalRule proto, ValidatorIndex index) throws ValidationException {
            EnumValidation.definedOnly((String)".banyandb.common.v1.IntervalRule.unit", (ProtocolMessageEnum)proto.getUnit());
            ComparativeValidation.greaterThan((String)".banyandb.common.v1.IntervalRule.num", (Object)proto.getNum(), (Object)this.NUM__GT, Comparator.naturalOrder());
        }
    }

    public static class ResourceOptsValidator
    implements ValidatorImpl<BanyandbCommon.ResourceOpts> {
        private final Integer SHARD_NUM__GT = 0;

        public void assertValid(BanyandbCommon.ResourceOpts proto, ValidatorIndex index) throws ValidationException {
            ComparativeValidation.greaterThan((String)".banyandb.common.v1.ResourceOpts.shard_num", (Object)proto.getShardNum(), (Object)this.SHARD_NUM__GT, Comparator.naturalOrder());
            if (proto.hasBlockInterval()) {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.block_interval", (GeneratedMessageV3)proto.getBlockInterval());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.block_interval", null);
            }
            if (proto.hasBlockInterval()) {
                index.validatorFor((Object)proto.getBlockInterval()).assertValid((Object)proto.getBlockInterval());
            }
            if (proto.hasSegmentInterval()) {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.segment_interval", (GeneratedMessageV3)proto.getSegmentInterval());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.segment_interval", null);
            }
            if (proto.hasSegmentInterval()) {
                index.validatorFor((Object)proto.getSegmentInterval()).assertValid((Object)proto.getSegmentInterval());
            }
            if (proto.hasTtl()) {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.ttl", (GeneratedMessageV3)proto.getTtl());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.ResourceOpts.ttl", null);
            }
            if (proto.hasTtl()) {
                index.validatorFor((Object)proto.getTtl()).assertValid((Object)proto.getTtl());
            }
        }
    }

    public static class GroupValidator
    implements ValidatorImpl<BanyandbCommon.Group> {
        public void assertValid(BanyandbCommon.Group proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.common.v1.Group.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.common.v1.Group.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasResourceOpts()) {
                index.validatorFor((Object)proto.getResourceOpts()).assertValid((Object)proto.getResourceOpts());
            }
            if (proto.hasUpdatedAt()) {
                index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
            }
        }
    }
}

