/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import java.time.ZonedDateTime;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.v1.client.metadata.AutoValue_Group;
import org.apache.skywalking.banyandb.v1.client.metadata.Catalog;
import org.apache.skywalking.banyandb.v1.client.metadata.IntervalRule;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Group
extends NamedSchema<BanyandbCommon.Group> {
    abstract Catalog catalog();

    abstract int shardNum();

    abstract IntervalRule blockInterval();

    abstract IntervalRule segmentInterval();

    abstract IntervalRule ttl();

    public static Group create(String name, Catalog catalog, int shardNum, IntervalRule blockInterval, IntervalRule segmentInterval, IntervalRule ttl) {
        return new AutoValue_Group(null, name, null, catalog, shardNum, blockInterval, segmentInterval, ttl);
    }

    public static Group create(String name, Catalog catalog, int shardNum, IntervalRule blockInterval, IntervalRule segmentInterval, IntervalRule ttl, ZonedDateTime updatedAt) {
        return new AutoValue_Group(null, name, updatedAt, catalog, shardNum, blockInterval, segmentInterval, ttl);
    }

    @Override
    public BanyandbCommon.Group serialize() {
        return BanyandbCommon.Group.newBuilder().setMetadata(this.buildMetadata().toBuilder()).setCatalog(this.catalog().getCatalog()).setResourceOpts(BanyandbCommon.ResourceOpts.newBuilder().setShardNum(this.shardNum()).setBlockInterval(this.blockInterval().serialize()).setSegmentInterval(this.segmentInterval().serialize()).setTtl(this.ttl().serialize()).build()).build();
    }

    public static Group fromProtobuf(BanyandbCommon.Group group) {
        Catalog catalog = Catalog.UNSPECIFIED;
        switch (group.getCatalog()) {
            case CATALOG_STREAM: {
                catalog = Catalog.STREAM;
                break;
            }
            case CATALOG_MEASURE: {
                catalog = Catalog.MEASURE;
            }
        }
        return new AutoValue_Group(null, group.getMetadata().getName(), TimeUtils.parseTimestamp(group.getUpdatedAt()), catalog, group.getResourceOpts().getShardNum(), IntervalRule.fromProtobuf(group.getResourceOpts().getBlockInterval()), IntervalRule.fromProtobuf(group.getResourceOpts().getSegmentInterval()), IntervalRule.fromProtobuf(group.getResourceOpts().getTtl()));
    }
}

