/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import io.grpc.Channel;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.database.v1.GroupRegistryServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.MetadataClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;

public class GroupMetadataRegistry
extends MetadataClient<GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub, BanyandbCommon.Group, Group> {
    public GroupMetadataRegistry(Channel channel) {
        super(GroupRegistryServiceGrpc.newBlockingStub(channel));
    }

    @Override
    public void create(Group payload) throws BanyanDBException {
        this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).create(BanyandbDatabase.GroupRegistryServiceCreateRequest.newBuilder().setGroup(payload.serialize()).build()));
    }

    @Override
    public void update(Group payload) throws BanyanDBException {
        this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).update(BanyandbDatabase.GroupRegistryServiceUpdateRequest.newBuilder().setGroup(payload.serialize()).build()));
    }

    @Override
    public boolean delete(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceDeleteResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).delete(BanyandbDatabase.GroupRegistryServiceDeleteRequest.newBuilder().setGroup(name).build()));
        return resp != null && resp.getDeleted();
    }

    @Override
    public Group get(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceGetResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).get(BanyandbDatabase.GroupRegistryServiceGetRequest.newBuilder().setGroup(name).build()));
        return Group.fromProtobuf(resp.getGroup());
    }

    @Override
    public ResourceExist exist(String group, String name) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceExistResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).exist(BanyandbDatabase.GroupRegistryServiceExistRequest.newBuilder().setGroup(name).build()));
        return ResourceExist.create(resp.getHasGroup(), resp.getHasGroup());
    }

    @Override
    public List<Group> list(String group) throws BanyanDBException {
        BanyandbDatabase.GroupRegistryServiceListResponse resp = this.execute(() -> ((GroupRegistryServiceGrpc.GroupRegistryServiceBlockingStub)this.stub).list(BanyandbDatabase.GroupRegistryServiceListRequest.newBuilder().build()));
        return resp.getGroupList().stream().map(Group::fromProtobuf).collect(Collectors.toList());
    }
}

