/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.;
import org.apache.skywalking.banyandb.v1.client.metadata.Duration;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;
import org.apache.skywalking.banyandb.v1.client.metadata.TagFamilySpec;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Measure
extends NamedSchema<BanyandbDatabase.Measure> {
    abstract ImmutableList<TagFamilySpec> tagFamilies();

    abstract ImmutableList<FieldSpec> fields();

    abstract ImmutableList<String> entityRelativeTags();

    abstract Duration interval();

    public abstract ImmutableList<IndexRule> indexRules();

    public abstract Builder toBuilder();

    public final Measure withIndexRules(List<IndexRule> indexRules) {
        return this.toBuilder().addIndexes(indexRules).build();
    }

    public static Builder create(String group, String name, Duration interval) {
        return new .AutoValue_Measure.Builder().setGroup(group).setName(name).setInterval(interval);
    }

    static Measure fromProtobuf(BanyandbDatabase.Measure pb) {
        int i;
        Builder m = Measure.create(pb.getMetadata().getGroup(), pb.getMetadata().getName(), Duration.parse(pb.getInterval())).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt())).setEntityRelativeTags((List<String>)pb.getEntity().getTagNamesList());
        for (i = 0; i < pb.getTagFamiliesCount(); ++i) {
            m.addTagFamily(TagFamilySpec.fromProtobuf(pb.getTagFamilies(i)));
        }
        for (i = 0; i < pb.getFieldsCount(); ++i) {
            m.addField(FieldSpec.fromProtobuf(pb.getFields(i)));
        }
        return m.build();
    }

    @Override
    public BanyandbDatabase.Measure serialize() {
        ArrayList<BanyandbDatabase.TagFamilySpec> tfs = new ArrayList<BanyandbDatabase.TagFamilySpec>(this.tagFamilies().size());
        for (TagFamilySpec spec : this.tagFamilies()) {
            tfs.add(spec.serialize());
        }
        ArrayList<BanyandbDatabase.FieldSpec> fs = new ArrayList<BanyandbDatabase.FieldSpec>(this.fields().size());
        for (FieldSpec spec : this.fields()) {
            fs.add(spec.serialize());
        }
        BanyandbDatabase.Measure.Builder b = BanyandbDatabase.Measure.newBuilder().setInterval(this.interval().format()).setMetadata(this.buildMetadata()).addAllTagFamilies(tfs).addAllFields(fs).setEntity(BanyandbDatabase.Entity.newBuilder().addAllTagNames((Iterable<String>)this.entityRelativeTags()).build());
        if (this.updatedAt() != null) {
            b.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return b.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract String group();

        abstract ImmutableList<TagFamilySpec> tagFamilies();

        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        abstract ImmutableList.Builder<TagFamilySpec> tagFamiliesBuilder();

        public final Builder addTagFamily(TagFamilySpec tagFamilySpec) {
            this.tagFamiliesBuilder().add((Object)tagFamilySpec);
            return this;
        }

        public final Builder addTagFamilies(Iterable<TagFamilySpec> tagFamilySpecs) {
            this.tagFamiliesBuilder().addAll(tagFamilySpecs);
            return this;
        }

        abstract ImmutableList.Builder<FieldSpec> fieldsBuilder();

        public final Builder addField(FieldSpec fieldSpec) {
            this.fieldsBuilder().add((Object)fieldSpec);
            return this;
        }

        abstract ImmutableList.Builder<IndexRule> indexRulesBuilder();

        public final Builder addIndexes(Iterable<IndexRule> indexRules) {
            for (IndexRule ir : indexRules) {
                this.addIndex(ir);
            }
            return this;
        }

        public final Builder addIndex(IndexRule indexRule) {
            this.indexRulesBuilder().add((Object)indexRule.withGroup(this.group()));
            return this;
        }

        abstract Builder setInterval(Duration var1);

        public abstract Builder setEntityRelativeTags(List<String> var1);

        public abstract Builder setEntityRelativeTags(String ... var1);

        public abstract Measure build();
    }

    public static class FieldSpec
    implements Serializable<BanyandbDatabase.FieldSpec> {
        private final String name;
        private final FieldType fieldType;
        private final EncodingMethod encodingMethod;
        private final CompressionMethod compressionMethod;

        private FieldSpec(Builder builder) {
            this.name = builder.name;
            this.fieldType = builder.fieldType;
            this.encodingMethod = builder.encodingMethod;
            this.compressionMethod = builder.compressionMethod;
        }

        @Override
        public BanyandbDatabase.FieldSpec serialize() {
            return BanyandbDatabase.FieldSpec.newBuilder().setName(this.name).setFieldType(this.fieldType.fieldType).setEncodingMethod(this.encodingMethod.encodingMethod).setCompressionMethod(this.compressionMethod.compressionMethod).build();
        }

        private static FieldSpec fromProtobuf(BanyandbDatabase.FieldSpec pb) {
            Builder b = null;
            switch (pb.getFieldType()) {
                case FIELD_TYPE_STRING: {
                    b = FieldSpec.newStringField(pb.getName());
                    break;
                }
                case FIELD_TYPE_INT: {
                    b = FieldSpec.newIntField(pb.getName());
                    break;
                }
                case FIELD_TYPE_DATA_BINARY: {
                    b = FieldSpec.newBinaryField(pb.getName());
                    break;
                }
                case FIELD_TYPE_FLOAT: {
                    b = FieldSpec.newFloatField(pb.getName());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unrecognized field type");
                }
            }
            switch (pb.getEncodingMethod()) {
                case ENCODING_METHOD_GORILLA: {
                    b.encodeWithGorilla();
                }
            }
            switch (pb.getCompressionMethod()) {
                case COMPRESSION_METHOD_ZSTD: {
                    b.compressWithZSTD();
                }
            }
            return b.build();
        }

        public static Builder newFloatField(String name) {
            return new Builder(name, FieldType.FLOAT);
        }

        public static Builder newStringField(String name) {
            return new Builder(name, FieldType.STRING);
        }

        public static Builder newIntField(String name) {
            return new Builder(name, FieldType.INT);
        }

        public static Builder newBinaryField(String name) {
            return new Builder(name, FieldType.BINARY);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldSpec)) {
                return false;
            }
            FieldSpec other = (FieldSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            FieldType this$fieldType = this.fieldType;
            FieldType other$fieldType = other.fieldType;
            if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
                return false;
            }
            EncodingMethod this$encodingMethod = this.encodingMethod;
            EncodingMethod other$encodingMethod = other.encodingMethod;
            if (this$encodingMethod == null ? other$encodingMethod != null : !((Object)((Object)this$encodingMethod)).equals((Object)other$encodingMethod)) {
                return false;
            }
            CompressionMethod this$compressionMethod = this.compressionMethod;
            CompressionMethod other$compressionMethod = other.compressionMethod;
            return !(this$compressionMethod == null ? other$compressionMethod != null : !((Object)((Object)this$compressionMethod)).equals((Object)other$compressionMethod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            FieldType $fieldType = this.fieldType;
            result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
            EncodingMethod $encodingMethod = this.encodingMethod;
            result = result * 59 + ($encodingMethod == null ? 43 : ((Object)((Object)$encodingMethod)).hashCode());
            CompressionMethod $compressionMethod = this.compressionMethod;
            result = result * 59 + ($compressionMethod == null ? 43 : ((Object)((Object)$compressionMethod)).hashCode());
            return result;
        }

        public String getName() {
            return this.name;
        }

        public static final class Builder {
            private final String name;
            private final FieldType fieldType;
            private EncodingMethod encodingMethod;
            private CompressionMethod compressionMethod;

            private Builder(String name, FieldType fieldType) {
                this.name = name;
                this.fieldType = fieldType;
                this.encodingMethod = EncodingMethod.UNSPECIFIED;
                this.compressionMethod = CompressionMethod.UNSPECIFIED;
            }

            public Builder encodeWithGorilla() {
                this.encodingMethod = EncodingMethod.GORILLA;
                return this;
            }

            public Builder compressWithZSTD() {
                this.compressionMethod = CompressionMethod.ZSTD;
                return this;
            }

            public FieldSpec build() {
                return new FieldSpec(this);
            }
        }

        public static enum FieldType {
            UNSPECIFIED(BanyandbDatabase.FieldType.FIELD_TYPE_UNSPECIFIED),
            STRING(BanyandbDatabase.FieldType.FIELD_TYPE_STRING),
            INT(BanyandbDatabase.FieldType.FIELD_TYPE_INT),
            BINARY(BanyandbDatabase.FieldType.FIELD_TYPE_DATA_BINARY),
            FLOAT(BanyandbDatabase.FieldType.FIELD_TYPE_FLOAT);

            private final BanyandbDatabase.FieldType fieldType;

            private FieldType(BanyandbDatabase.FieldType fieldType) {
                this.fieldType = fieldType;
            }
        }

        public static enum EncodingMethod {
            UNSPECIFIED(BanyandbDatabase.EncodingMethod.ENCODING_METHOD_UNSPECIFIED),
            GORILLA(BanyandbDatabase.EncodingMethod.ENCODING_METHOD_GORILLA);

            private final BanyandbDatabase.EncodingMethod encodingMethod;

            private EncodingMethod(BanyandbDatabase.EncodingMethod encodingMethod) {
                this.encodingMethod = encodingMethod;
            }
        }

        public static enum CompressionMethod {
            UNSPECIFIED(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_UNSPECIFIED),
            ZSTD(BanyandbDatabase.CompressionMethod.COMPRESSION_METHOD_ZSTD);

            private final BanyandbDatabase.CompressionMethod compressionMethod;

            private CompressionMethod(BanyandbDatabase.CompressionMethod compressionMethod) {
                this.compressionMethod = compressionMethod;
            }
        }
    }
}

