/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.v1.client.TagAndValue;
import org.apache.skywalking.banyandb.v1.client.metadata.;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class Property
extends NamedSchema<BanyandbProperty.Property> {
    public abstract String id();

    public abstract ImmutableList<TagAndValue<?>> tags();

    @Override
    public BanyandbProperty.Property serialize() {
        ArrayList<BanyandbModel.Tag> tags = new ArrayList<BanyandbModel.Tag>(this.tags().size());
        for (TagAndValue tagAndValue : this.tags()) {
            tags.add(tagAndValue.build());
        }
        return BanyandbProperty.Property.newBuilder().setMetadata(BanyandbProperty.Metadata.newBuilder().setId(this.id()).setContainer(this.buildMetadata()).build()).addAllTags(tags).build();
    }

    public static Builder create(String group, String name, String id) {
        return new .AutoValue_Property.Builder().setGroup(group).setName(name).setId(id);
    }

    static Property fromProtobuf(BanyandbProperty.Property pb) {
        Builder b = Property.create(pb.getMetadata().getContainer().getGroup(), pb.getMetadata().getContainer().getName(), pb.getMetadata().getId()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt()));
        for (int i = 0; i < pb.getTagsCount(); ++i) {
            b.addTag(TagAndValue.fromProtobuf(pb.getTags(i)));
        }
        return b.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        public abstract Builder setId(String var1);

        abstract ImmutableList.Builder<TagAndValue<?>> tagsBuilder();

        public final Builder addTag(TagAndValue<?> tagAndValue) {
            this.tagsBuilder().add(tagAndValue);
            return this;
        }

        public abstract Property build();
    }
}

