/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.AutoValue_TagFamilySpec;
import org.apache.skywalking.banyandb.v1.client.metadata.Serializable;

@AutoValue
public abstract class TagFamilySpec
implements Serializable<BanyandbDatabase.TagFamilySpec> {
    public abstract String tagFamilyName();

    public abstract ImmutableList<TagSpec> tagSpecs();

    public static Builder create(String tagFamilyName) {
        return new AutoValue_TagFamilySpec.Builder().setTagFamilyName(tagFamilyName);
    }

    @Override
    public BanyandbDatabase.TagFamilySpec serialize() {
        ArrayList<BanyandbDatabase.TagSpec> metadataTagSpecs = new ArrayList<BanyandbDatabase.TagSpec>(this.tagSpecs().size());
        for (TagSpec spec : this.tagSpecs()) {
            metadataTagSpecs.add(spec.serialize());
        }
        return BanyandbDatabase.TagFamilySpec.newBuilder().setName(this.tagFamilyName()).addAllTags(metadataTagSpecs).build();
    }

    public static TagFamilySpec fromProtobuf(BanyandbDatabase.TagFamilySpec pb) {
        Builder builder = TagFamilySpec.create(pb.getName());
        block8: for (int j = 0; j < pb.getTagsCount(); ++j) {
            BanyandbDatabase.TagSpec ts = pb.getTags(j);
            String tagName = ts.getName();
            switch (ts.getType()) {
                case TAG_TYPE_INT: {
                    builder.addTagSpec(TagSpec.newIntTag(tagName));
                    continue block8;
                }
                case TAG_TYPE_STRING: {
                    builder.addTagSpec(TagSpec.newStringTag(tagName));
                    continue block8;
                }
                case TAG_TYPE_INT_ARRAY: {
                    builder.addTagSpec(TagSpec.newIntArrayTag(tagName));
                    continue block8;
                }
                case TAG_TYPE_STRING_ARRAY: {
                    builder.addTagSpec(TagSpec.newStringArrayTag(tagName));
                    continue block8;
                }
                case TAG_TYPE_DATA_BINARY: {
                    builder.addTagSpec(TagSpec.newBinaryTag(tagName));
                    continue block8;
                }
                case TAG_TYPE_ID: {
                    builder.addTagSpec(TagSpec.newIDTag(tagName));
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("unrecognized tag type");
                }
            }
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setTagFamilyName(String var1);

        abstract ImmutableList.Builder<TagSpec> tagSpecsBuilder();

        public final Builder addTagSpec(TagSpec tagSpec) {
            this.tagSpecsBuilder().add((Object)tagSpec);
            return this;
        }

        public final Builder addTagSpecs(Iterable<TagSpec> tagSpecs) {
            this.tagSpecsBuilder().addAll(tagSpecs);
            return this;
        }

        public abstract TagFamilySpec build();
    }

    public static class TagSpec
    implements Serializable<BanyandbDatabase.TagSpec> {
        private final String tagName;
        private final TagType tagType;
        private boolean indexedOnly;

        private TagSpec(String tagName, TagType tagType) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tagName) ? 1 : 0) != 0, (Object)"tagName must not be null or empty");
            this.tagName = tagName;
            this.tagType = tagType;
        }

        public static TagSpec newIntTag(String name) {
            return new TagSpec(name, TagType.INT);
        }

        public static TagSpec newStringTag(String name) {
            return new TagSpec(name, TagType.STRING);
        }

        public static TagSpec newIntArrayTag(String name) {
            return new TagSpec(name, TagType.INT_ARRAY);
        }

        public static TagSpec newStringArrayTag(String name) {
            return new TagSpec(name, TagType.STRING_ARRAY);
        }

        public static TagSpec newBinaryTag(String name) {
            return new TagSpec(name, TagType.BINARY);
        }

        private static TagSpec newIDTag(String name) {
            return new TagSpec(name, TagType.ID);
        }

        public TagSpec indexedOnly() {
            this.indexedOnly = true;
            return this;
        }

        @Override
        public BanyandbDatabase.TagSpec serialize() {
            return BanyandbDatabase.TagSpec.newBuilder().setName(this.tagName).setType(this.tagType.getTagType()).setIndexedOnly(this.indexedOnly).build();
        }

        public String getTagName() {
            return this.tagName;
        }

        public TagType getTagType() {
            return this.tagType;
        }

        public boolean isIndexedOnly() {
            return this.indexedOnly;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagSpec)) {
                return false;
            }
            TagSpec other = (TagSpec)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIndexedOnly() != other.isIndexedOnly()) {
                return false;
            }
            String this$tagName = this.getTagName();
            String other$tagName = other.getTagName();
            if (this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName)) {
                return false;
            }
            TagType this$tagType = this.getTagType();
            TagType other$tagType = other.getTagType();
            return !(this$tagType == null ? other$tagType != null : !((Object)((Object)this$tagType)).equals((Object)other$tagType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TagSpec;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIndexedOnly() ? 79 : 97);
            String $tagName = this.getTagName();
            result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
            TagType $tagType = this.getTagType();
            result = result * 59 + ($tagType == null ? 43 : ((Object)((Object)$tagType)).hashCode());
            return result;
        }

        public static enum TagType {
            INT(BanyandbDatabase.TagType.TAG_TYPE_INT),
            STRING(BanyandbDatabase.TagType.TAG_TYPE_STRING),
            INT_ARRAY(BanyandbDatabase.TagType.TAG_TYPE_INT_ARRAY),
            STRING_ARRAY(BanyandbDatabase.TagType.TAG_TYPE_STRING_ARRAY),
            BINARY(BanyandbDatabase.TagType.TAG_TYPE_DATA_BINARY),
            ID(BanyandbDatabase.TagType.TAG_TYPE_ID);

            private final BanyandbDatabase.TagType tagType;

            private TagType(BanyandbDatabase.TagType tagType) {
                this.tagType = tagType;
            }

            private BanyandbDatabase.TagType getTagType() {
                return this.tagType;
            }
        }
    }
}

