/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;

public class MapSolrParams
extends SolrParams {
    protected final Map<String, String> map;

    public MapSolrParams(Map<String, String> map) {
        this.map = map;
    }

    @Override
    public String get(String name) {
        return this.map.get(name);
    }

    @Override
    public String[] getParams(String name) {
        String[] stringArray;
        String val = this.map.get(name);
        if (val == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = val;
        }
        return stringArray;
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.map.keySet().iterator();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        try {
            boolean first = true;
            for (Map.Entry<String, String> entry : this.map.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (!first) {
                    sb.append('&');
                }
                first = false;
                sb.append(key);
                sb.append('=');
                StrUtils.partialURLEncodeVal(sb, val == null ? "" : val);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

