/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterState
implements JSONWriter.Writable {
    private static Logger log = LoggerFactory.getLogger(ClusterState.class);
    private Integer zkClusterStateVersion;
    private final Map<String, DocCollection> collectionStates;
    private Set<String> liveNodes;

    @Deprecated
    public ClusterState(Set<String> liveNodes, Map<String, DocCollection> collectionStates) {
        this(null, liveNodes, collectionStates);
    }

    public ClusterState(Integer zkClusterStateVersion, Set<String> liveNodes, Map<String, DocCollection> collectionStates) {
        this.zkClusterStateVersion = zkClusterStateVersion;
        this.liveNodes = new HashSet<String>(liveNodes.size());
        this.liveNodes.addAll(liveNodes);
        this.collectionStates = new LinkedHashMap<String, DocCollection>(collectionStates.size());
        this.collectionStates.putAll(collectionStates);
    }

    public ClusterState copyWith(Map<String, DocCollection> modified) {
        ClusterState result = new ClusterState(this.zkClusterStateVersion, this.liveNodes, this.collectionStates);
        for (Map.Entry<String, DocCollection> e : modified.entrySet()) {
            DocCollection c = e.getValue();
            if (c == null) {
                result.collectionStates.remove(e.getKey());
                continue;
            }
            result.collectionStates.put(c.getName(), c);
        }
        return result;
    }

    public Replica getLeader(String collection, String sliceName) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        Slice slice = coll.getSlice(sliceName);
        if (slice == null) {
            return null;
        }
        return slice.getLeader();
    }

    private Replica getReplica(DocCollection coll, String replicaName) {
        if (coll == null) {
            return null;
        }
        for (Slice slice : coll.getSlices()) {
            Replica replica = slice.getReplica(replicaName);
            if (replica == null) continue;
            return replica;
        }
        return null;
    }

    public boolean hasCollection(String coll) {
        return this.collectionStates.containsKey(coll);
    }

    public Replica getReplica(String collection, String coreNodeName) {
        return this.getReplica(this.collectionStates.get(collection), coreNodeName);
    }

    public Slice getSlice(String collection, String sliceName) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlice(sliceName);
    }

    public Map<String, Slice> getSlicesMap(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlicesMap();
    }

    public Map<String, Slice> getActiveSlicesMap(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getActiveSlicesMap();
    }

    public Collection<Slice> getSlices(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getSlices();
    }

    public Collection<Slice> getActiveSlices(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            return null;
        }
        return coll.getActiveSlices();
    }

    public DocCollection getCollection(String collection) {
        DocCollection coll = this.getCollectionOrNull(collection);
        if (coll == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection : " + collection);
        }
        return coll;
    }

    public DocCollection getCollectionOrNull(String coll) {
        return this.collectionStates.get(coll);
    }

    public Set<String> getCollections() {
        return this.collectionStates.keySet();
    }

    public Map<String, DocCollection> getCollectionStates() {
        return Collections.unmodifiableMap(this.collectionStates);
    }

    public Set<String> getLiveNodes() {
        return Collections.unmodifiableSet(this.liveNodes);
    }

    public String getShardId(String nodeName, String coreName) {
        return this.getShardId(null, nodeName, coreName);
    }

    public String getShardId(String collectionName, String nodeName, String coreName) {
        DocCollection c;
        Collection<DocCollection> states = this.collectionStates.values();
        if (collectionName != null && (c = this.getCollectionOrNull(collectionName)) != null) {
            states = Collections.singletonList(c);
        }
        for (DocCollection coll : states) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    String rnodeName = replica.getStr("node_name");
                    String rcore = replica.getStr("core");
                    if (!nodeName.equals(rnodeName) || !coreName.equals(rcore)) continue;
                    return slice.getName();
                }
            }
        }
        return null;
    }

    public String getShardIdByCoreNodeName(String collectionName, String coreNodeName) {
        DocCollection c;
        Collection<DocCollection> states = this.collectionStates.values();
        if (collectionName != null && (c = this.getCollectionOrNull(collectionName)) != null) {
            states = Collections.singletonList(c);
        }
        for (DocCollection coll : states) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!coreNodeName.equals(replica.getName())) continue;
                    return slice.getName();
                }
            }
        }
        return null;
    }

    public boolean liveNodesContain(String name) {
        return this.liveNodes.contains(name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("live nodes:" + this.liveNodes);
        sb.append(" collections:" + this.collectionStates);
        return sb.toString();
    }

    public static ClusterState load(SolrZkClient zkClient, Set<String> liveNodes, ZkStateReader stateReader) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        byte[] state = zkClient.getData("/clusterstate.json", null, stat, true);
        return ClusterState.load(stat.getVersion(), state, liveNodes);
    }

    public static ClusterState load(Integer version, byte[] bytes, Set<String> liveNodes) {
        if (bytes == null || bytes.length == 0) {
            return new ClusterState(version, liveNodes, Collections.emptyMap());
        }
        Map stateMap = (Map)ZkStateReader.fromJSON(bytes);
        LinkedHashMap<String, DocCollection> collections = new LinkedHashMap<String, DocCollection>(stateMap.size());
        for (Map.Entry entry : stateMap.entrySet()) {
            String collectionName = (String)entry.getKey();
            DocCollection coll = ClusterState.collectionFromObjects(collectionName, (Map)entry.getValue(), version);
            collections.put(collectionName, coll);
        }
        return new ClusterState(version, liveNodes, collections);
    }

    public static Aliases load(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return new Aliases();
        }
        Map aliasMap = (Map)ZkStateReader.fromJSON(bytes);
        return new Aliases(aliasMap);
    }

    private static DocCollection collectionFromObjects(String name, Map<String, Object> objs, Integer version) {
        DocRouter router;
        Map<String, Object> props;
        Map<String, Slice> slices;
        Map sliceObjs = (Map)objs.get("shards");
        if (sliceObjs == null) {
            slices = ClusterState.makeSlices(objs);
            props = Collections.emptyMap();
        } else {
            slices = ClusterState.makeSlices(sliceObjs);
            props = new HashMap<String, Object>(objs);
            objs.remove("shards");
        }
        Object routerObj = props.get("router");
        if (routerObj == null) {
            router = DocRouter.DEFAULT;
        } else if (routerObj instanceof String) {
            router = DocRouter.getDocRouter((String)routerObj);
        } else {
            Map routerProps = (Map)routerObj;
            router = DocRouter.getDocRouter((String)routerProps.get("name"));
        }
        return new DocCollection(name, slices, props, router, version);
    }

    private static Map<String, Slice> makeSlices(Map<String, Object> genericSlices) {
        if (genericSlices == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Slice> result = new LinkedHashMap<String, Slice>(genericSlices.size());
        for (Map.Entry<String, Object> entry : genericSlices.entrySet()) {
            String name = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Slice) {
                result.put(name, (Slice)val);
                continue;
            }
            if (!(val instanceof Map)) continue;
            result.put(name, new Slice(name, null, (Map)val));
        }
        return result;
    }

    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.collectionStates);
    }

    public Integer getZkClusterStateVersion() {
        return this.zkClusterStateVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.zkClusterStateVersion == null ? 0 : this.zkClusterStateVersion.hashCode());
        result = 31 * result + (this.liveNodes == null ? 0 : this.liveNodes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClusterState other = (ClusterState)obj;
        if (this.zkClusterStateVersion == null ? other.zkClusterStateVersion != null : !this.zkClusterStateVersion.equals(other.zkClusterStateVersion)) {
            return false;
        }
        return !(this.liveNodes == null ? other.liveNodes != null : !this.liveNodes.equals(other.liveNodes));
    }

    void setLiveNodes(Set<String> liveNodes) {
        this.liveNodes = liveNodes;
    }

    public DocCollection getCommonCollection(String name) {
        return this.collectionStates.get(name);
    }
}

