/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.memory;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryAllocator;
import org.apache.spark.unsafe.memory.MemoryBlock;

public class HeapMemoryAllocator
implements MemoryAllocator {
    @GuardedBy(value="this")
    private final Map<Long, LinkedList<WeakReference<long[]>>> bufferPoolsBySize = new HashMap<Long, LinkedList<WeakReference<long[]>>>();
    private static final int POOLING_THRESHOLD_BYTES = 0x100000;

    private boolean shouldPool(long size) {
        return size >= 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MemoryBlock allocate(long size) throws OutOfMemoryError {
        if (this.shouldPool(size)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<long[]>> pool = this.bufferPoolsBySize.get(size);
                if (pool != null) {
                    while (!pool.isEmpty()) {
                        WeakReference<long[]> arrayReference = pool.pop();
                        long[] array = (long[])arrayReference.get();
                        if (array == null) continue;
                        assert ((long)array.length * 8L >= size);
                        MemoryBlock memory = new MemoryBlock(array, Platform.LONG_ARRAY_OFFSET, size);
                        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
                            memory.fill((byte)-91);
                        }
                        return memory;
                    }
                    this.bufferPoolsBySize.remove(size);
                }
            }
        }
        long[] array = new long[(int)((size + 7L) / 8L)];
        MemoryBlock memory = new MemoryBlock(array, Platform.LONG_ARRAY_OFFSET, size);
        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
            memory.fill((byte)-91);
        }
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(MemoryBlock memory) {
        assert (memory.obj != null) : "baseObject was null; are you trying to use the on-heap allocator to free off-heap memory?";
        assert (memory.pageNumber != -3) : "page has already been freed";
        assert (memory.pageNumber == -1 || memory.pageNumber == -2) : "TMM-allocated pages must first be freed via TMM.freePage(), not directly in allocator free()";
        long size = memory.size();
        if (MemoryAllocator.MEMORY_DEBUG_FILL_ENABLED) {
            memory.fill((byte)90);
        }
        memory.pageNumber = -3;
        long[] array = (long[])memory.obj;
        memory.setObjAndOffset(null, 0L);
        if (this.shouldPool(size)) {
            HeapMemoryAllocator heapMemoryAllocator = this;
            synchronized (heapMemoryAllocator) {
                LinkedList<WeakReference<Object>> pool = this.bufferPoolsBySize.get(size);
                if (pool == null) {
                    pool = new LinkedList();
                    this.bufferPoolsBySize.put(size, pool);
                }
                pool.add(new WeakReference<long[]>(array));
            }
        }
    }
}

