/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import org.apache.tapestry5.internal.plastic.InstructionBuilderState;
import org.apache.tapestry5.internal.plastic.Lockable;
import org.apache.tapestry5.internal.plastic.asm.Label;
import org.apache.tapestry5.internal.plastic.asm.Opcodes;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.SwitchBlock;
import org.apache.tapestry5.plastic.SwitchCallback;

public class SwitchBlockImpl
extends Lockable
implements SwitchBlock,
Opcodes {
    private final InstructionBuilder builder;
    private final InstructionBuilderState state;
    private final int min;
    private final int max;
    private final Label defaultLabel;
    private final Label endSwitchLabel;
    private final Label[] caseLabels;
    private boolean defaultAdded = false;

    SwitchBlockImpl(InstructionBuilder builder, InstructionBuilderState state, int min, int max) {
        assert (min <= max);
        this.builder = builder;
        this.state = state;
        this.min = min;
        this.max = max;
        this.defaultLabel = new Label();
        this.endSwitchLabel = new Label();
        this.caseLabels = new Label[max - min + 1];
        for (int i = min; i <= max; ++i) {
            this.caseLabels[i - min] = new Label();
        }
        state.visitor.visitTableSwitchInsn(min, max, this.defaultLabel, this.caseLabels);
    }

    void doCallback(SwitchCallback callback) {
        this.check();
        callback.doSwitch(this);
        if (!this.defaultAdded) {
            this.addDefault(new InstructionBuilderCallback(){

                @Override
                public void doBuild(InstructionBuilder builder) {
                    builder.throwException(IllegalArgumentException.class, "Switch value not matched in case statement.");
                }
            });
        }
        this.state.visitor.visitLabel(this.endSwitchLabel);
        this.lock();
    }

    @Override
    public void addCase(int caseValue, boolean jumpToEnd, InstructionBuilderCallback callback) {
        assert (caseValue >= this.min);
        assert (caseValue <= this.max);
        if (this.defaultAdded) {
            throw new IllegalStateException("The default block must come last.");
        }
        this.state.visitor.visitLabel(this.caseLabels[caseValue - this.min]);
        callback.doBuild(this.builder);
        if (jumpToEnd) {
            this.state.visitor.visitJumpInsn(167, this.endSwitchLabel);
        }
    }

    @Override
    public void addDefault(InstructionBuilderCallback callback) {
        if (this.defaultAdded) {
            throw new IllegalStateException("A SwitchBlock may only have one default block.");
        }
        this.state.visitor.visitLabel(this.defaultLabel);
        callback.doBuild(this.builder);
        this.defaultAdded = true;
    }
}

