/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.util.List;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InitializationPlan;

public class ConstructionPlan<T>
implements ObjectCreator<T> {
    private final OperationTracker tracker;
    private final String description;
    private final Invokable<T> instanceConstructor;
    private List<InitializationPlan> initializationPlans;

    public ConstructionPlan(OperationTracker tracker, String description, Invokable<T> instanceConstructor) {
        this.tracker = tracker;
        this.description = description;
        this.instanceConstructor = instanceConstructor;
    }

    public ConstructionPlan add(InitializationPlan plan) {
        if (this.initializationPlans == null) {
            this.initializationPlans = CollectionFactory.newList();
        }
        this.initializationPlans.add(plan);
        return this;
    }

    public T createObject() {
        T result = this.tracker.invoke(this.description, this.instanceConstructor);
        if (this.initializationPlans != null) {
            this.executeInitializationPLans(result);
        }
        return result;
    }

    private void executeInitializationPLans(final T newInstance) {
        for (final InitializationPlan plan : this.initializationPlans) {
            this.tracker.run(plan.getDescription(), new Runnable(){

                @Override
                public void run() {
                    plan.initialize(newInstance);
                }
            });
        }
    }
}

