/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.client.websocket;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.zeppelin.client.websocket.CompositeMessageHandler;
import org.apache.zeppelin.client.websocket.MessageHandler;
import org.apache.zeppelin.client.websocket.StatementMessageHandler;
import org.apache.zeppelin.common.Message;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket(maxTextMessageSize=10240000)
public class ZeppelinWebSocketClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeppelinWebSocketClient.class);
    private static final Gson GSON = new Gson();
    private CountDownLatch connectLatch = new CountDownLatch(1);
    private CountDownLatch closeLatch = new CountDownLatch(1);
    private Session session;
    private MessageHandler messageHandler;
    private WebSocketClient wsClient;

    public ZeppelinWebSocketClient(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void connect(String url) throws Exception {
        this.wsClient = new WebSocketClient();
        this.wsClient.start();
        URI echoUri = new URI(url);
        ClientUpgradeRequest request = new ClientUpgradeRequest();
        request.setHeader("Origin", "*");
        this.wsClient.connect((Object)this, echoUri, request);
        this.connectLatch.await();
        LOGGER.info("WebSocket connect established");
    }

    public void addStatementMessageHandler(String statementId, StatementMessageHandler statementMessageHandler) throws Exception {
        if (!(this.messageHandler instanceof CompositeMessageHandler)) {
            throw new Exception("StatementMessageHandler is only supported by: " + CompositeMessageHandler.class.getSimpleName());
        }
        ((CompositeMessageHandler)this.messageHandler).addStatementMessageHandler(statementId, statementMessageHandler);
    }

    public boolean awaitClose(int duration, TimeUnit unit) throws InterruptedException {
        return this.closeLatch.await(duration, unit);
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOGGER.info("Connection closed, statusCode: {} - reason: {}", (Object)statusCode, (Object)reason);
        this.session = null;
        this.closeLatch.countDown();
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOGGER.info("Got connect: {}", (Object)session.getRemote());
        this.session = session;
        this.connectLatch.countDown();
    }

    @OnWebSocketMessage
    public void onText(Session session, String message) throws IOException {
        this.messageHandler.onMessage(message);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        LOGGER.info("WebSocket Error: " + cause.getMessage());
        cause.printStackTrace(System.out);
    }

    public void send(Message message) throws IOException {
        this.session.getRemote().sendString(GSON.toJson((Object)message));
    }

    public CountDownLatch getConnectLatch() {
        return this.connectLatch;
    }

    public void stop() throws Exception {
        if (this.wsClient != null) {
            this.wsClient.stop();
        }
    }
}

