/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.logout;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.configuration.model.core.logout.LogoutProperties;
import org.apereo.cas.util.Pac4jUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.support.CookieRetrievingCookieGenerator;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.profile.ProfileManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TerminateSessionAction
extends AbstractAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TerminateSessionAction.class);
    public static final String REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED = "LogoutRequestConfirmed";
    protected final EventFactorySupport eventFactorySupport = new EventFactorySupport();
    protected final CentralAuthenticationService centralAuthenticationService;
    protected final CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator;
    protected final CookieRetrievingCookieGenerator warnCookieGenerator;
    protected final LogoutProperties logoutProperties;

    protected static boolean isLogoutRequestConfirmed(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        return request.getParameterMap().containsKey(REQUEST_PARAM_LOGOUT_REQUEST_CONFIRMED);
    }

    public Event doExecute(RequestContext requestContext) {
        Boolean terminateSession = (Boolean)FunctionUtils.doIf((boolean)this.logoutProperties.isConfirmLogout(), () -> TerminateSessionAction.isLogoutRequestConfirmed(requestContext), () -> Boolean.TRUE).get();
        if (terminateSession.booleanValue()) {
            return this.terminate(requestContext);
        }
        return this.eventFactorySupport.event((Object)this, "warn");
    }

    public Event terminate(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
        String tgtId = this.getTicketGrantingTicket(context);
        if (StringUtils.isNotBlank((CharSequence)tgtId)) {
            LOGGER.trace("Destroying SSO session linked to ticket-granting ticket [{}]", (Object)tgtId);
            List logoutRequests = this.centralAuthenticationService.destroyTicketGrantingTicket(tgtId);
            WebUtils.putLogoutRequests((RequestContext)context, (List)logoutRequests);
        }
        LOGGER.trace("Removing CAS cookies");
        this.ticketGrantingTicketCookieGenerator.removeCookie(response);
        this.warnCookieGenerator.removeCookie(response);
        this.destroyApplicationSession(request, response);
        LOGGER.debug("Terminated all CAS sessions successfully.");
        if (StringUtils.isNotBlank((CharSequence)this.logoutProperties.getRedirectUrl())) {
            WebUtils.putLogoutRedirectUrl((RequestContext)context, (String)this.logoutProperties.getRedirectUrl());
            return this.eventFactorySupport.event((Object)this, "redirect");
        }
        return this.eventFactorySupport.success((Object)this);
    }

    private String getTicketGrantingTicket(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)context);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return this.ticketGrantingTicketCookieGenerator.retrieveCookieValue(request);
        }
        return tgtId;
    }

    protected void destroyApplicationSession(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.trace("Destroying application session");
        ProfileManager manager = Pac4jUtils.getPac4jProfileManager((HttpServletRequest)request, (HttpServletResponse)response);
        manager.logout();
        HttpSession session = request.getSession(false);
        if (session != null) {
            Object requestedUrl = session.getAttribute("pac4jRequestedUrl");
            session.invalidate();
            if (requestedUrl != null && !requestedUrl.equals("")) {
                request.getSession(true).setAttribute("pac4jRequestedUrl", requestedUrl);
            }
        }
    }

    @Generated
    public TerminateSessionAction(CentralAuthenticationService centralAuthenticationService, CookieRetrievingCookieGenerator ticketGrantingTicketCookieGenerator, CookieRetrievingCookieGenerator warnCookieGenerator, LogoutProperties logoutProperties) {
        this.centralAuthenticationService = centralAuthenticationService;
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.warnCookieGenerator = warnCookieGenerator;
        this.logoutProperties = logoutProperties;
    }
}

