/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.web.support.CookieValueManager;
import org.apereo.cas.web.support.NoOpCookieValueManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieRetrievingCookieGenerator
extends CookieGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieRetrievingCookieGenerator.class);
    private static final int DEFAULT_REMEMBER_ME_MAX_AGE = 7889231;
    private int rememberMeMaxAge = 7889231;
    private CookieValueManager casCookieValueManager;

    public CookieRetrievingCookieGenerator(String name, String path, int maxAge, boolean secure, String domain, boolean httpOnly) {
        this(name, path, maxAge, secure, domain, new NoOpCookieValueManager(), 7889231, httpOnly);
    }

    public CookieRetrievingCookieGenerator(String name, String path, int maxAge, boolean secure, String domain, CookieValueManager casCookieValueManager, int rememberMeMaxAge, boolean httpOnly) {
        super.setCookieName(name);
        super.setCookiePath(path);
        this.setCookieDomain(domain);
        super.setCookieMaxAge(Integer.valueOf(maxAge));
        super.setCookieSecure(secure);
        super.setCookieHttpOnly(httpOnly);
        this.casCookieValueManager = casCookieValueManager;
        this.rememberMeMaxAge = rememberMeMaxAge;
    }

    public void addCookie(HttpServletRequest request, HttpServletResponse response, String cookieValue) {
        String theCookieValue = this.casCookieValueManager.buildCookieValue(cookieValue, request);
        if (StringUtils.isBlank((CharSequence)request.getParameter("rememberMe"))) {
            super.addCookie(response, theCookieValue);
        } else {
            Cookie cookie = this.createCookie(theCookieValue);
            cookie.setMaxAge(this.rememberMeMaxAge);
            cookie.setSecure(this.isCookieSecure());
            cookie.setHttpOnly(this.isCookieHttpOnly());
            response.addCookie(cookie);
        }
    }

    public String retrieveCookieValue(HttpServletRequest request) {
        try {
            Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
            return cookie == null ? null : this.casCookieValueManager.obtainCookieValue(cookie, request);
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setCookieDomain(String cookieDomain) {
        super.setCookieDomain((String)StringUtils.defaultIfEmpty((CharSequence)cookieDomain, null));
    }
}

