/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.geo;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.userinfo.client.UserInfo;
import io.userinfo.client.model.Info;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoLocationService
implements GeoLocationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeoLocationService.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    private String ipStackAccessKey;

    public GeoLocationResponse locate(String clientIp, GeoLocationRequest location) {
        LOGGER.debug("Attempting to find geolocation for [{}]", (Object)clientIp);
        GeoLocationResponse loc = this.locate(clientIp);
        if (loc == null && location != null) {
            LOGGER.debug("Attempting to find geolocation for [{}]", (Object)location);
            if (StringUtils.isNotBlank((CharSequence)location.getLatitude()) && StringUtils.isNotBlank((CharSequence)location.getLongitude())) {
                loc = this.locate(Double.valueOf(location.getLatitude()), Double.valueOf(location.getLongitude()));
            }
        }
        return loc;
    }

    public GeoLocationResponse locate(String address) {
        try {
            Info info = UserInfo.getInfo((String)address);
            if (info != null && info.getPosition() != null) {
                return this.locate(info.getPosition().getLatitude(), info.getPosition().getLongitude());
            }
            return null;
        }
        catch (Exception e) {
            String url;
            HttpResponse response;
            if (StringUtils.isNotBlank((CharSequence)this.ipStackAccessKey) && (response = HttpUtils.executeGet((String)(url = String.format("http://api.ipstack.com/%s?access_key=%s", address, this.ipStackAccessKey)))) != null && response.getStatusLine().getStatusCode() == 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                Map infos = (Map)MAPPER.readValue(result, Map.class);
                GeoLocationResponse geoResponse = new GeoLocationResponse();
                geoResponse.setLatitude(infos.getOrDefault("latitude", 0.0).doubleValue());
                geoResponse.setLongitude(infos.getOrDefault("longitude", 0.0).doubleValue());
                geoResponse.addAddress(infos.getOrDefault("city", "")).addAddress(infos.getOrDefault("region_name", "")).addAddress(infos.getOrDefault("region_code", "")).addAddress(infos.getOrDefault("county_name", ""));
                return geoResponse;
            }
            return null;
        }
    }

    @Generated
    public void setIpStackAccessKey(String ipStackAccessKey) {
        this.ipStackAccessKey = ipStackAccessKey;
    }

    @Generated
    public String getIpStackAccessKey() {
        return this.ipStackAccessKey;
    }
}

