/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.security.auth.login.FailedLoginException;
import javax.sql.DataSource;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class BindModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        HandlerResult handlerResult;
        block7: {
            if (this.getDataSource() == null) {
                throw new GeneralSecurityException("Authentication handler is not configured correctly");
            }
            Connection connection = null;
            try {
                String username = credential.getUsername();
                String password = credential.getPassword();
                connection = this.getDataSource().getConnection(username, password);
                handlerResult = this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
                if (connection == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new FailedLoginException(e.getMessage());
                    catch (Exception e2) {
                        throw new PreventedException("Unexpected SQL connection error", (Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (connection != null) {
                        DataSourceUtils.releaseConnection(connection, (DataSource)this.getDataSource());
                    }
                    throw throwable;
                }
            }
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.getDataSource());
        }
        return handlerResult;
    }
}

