/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.AbstractJdbcUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.springframework.dao.DataAccessException;

public class SearchModeSearchDatabaseAuthenticationHandler
extends AbstractJdbcUsernamePasswordAuthenticationHandler {
    private String fieldUser;
    private String fieldPassword;
    private String tableUsers;

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String sql = null;
        if (StringUtils.isNotBlank((CharSequence)this.tableUsers) || StringUtils.isNotBlank((CharSequence)this.fieldUser) || StringUtils.isNotBlank((CharSequence)this.fieldPassword)) {
            sql = "SELECT COUNT('x') FROM ".concat(this.tableUsers).concat(" WHERE ").concat(this.fieldUser).concat(" = ? AND ").concat(this.fieldPassword).concat("= ?");
        }
        if (StringUtils.isBlank(sql) || this.getJdbcTemplate() == null) {
            throw new GeneralSecurityException("Authentication handler is not configured correctly. No SQL statement or JDBC template found");
        }
        String username = credential.getUsername();
        try {
            this.logger.debug("Executing SQL query {}", (Object)sql);
            int count = (Integer)this.getJdbcTemplate().queryForObject(sql, Integer.class, new Object[]{username, credential.getPassword()});
            if (count == 0) {
                throw new FailedLoginException(username + " not found with SQL query.");
            }
            return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username), null);
        }
        catch (DataAccessException e) {
            throw new PreventedException("SQL exception while executing query for " + username, (Throwable)e);
        }
    }

    public void setFieldPassword(String fieldPassword) {
        this.fieldPassword = fieldPassword;
    }

    public void setFieldUser(String fieldUser) {
        this.fieldUser = fieldUser;
    }

    public void setTableUsers(String tableUsers) {
        this.tableUsers = tableUsers;
    }
}

