/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.jdbc.config;

import com.google.common.base.Predicates;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.jdbc.BindModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryAndEncodeDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.QueryDatabaseAuthenticationHandler;
import org.apereo.cas.adaptors.jdbc.SearchModeSearchDatabaseAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.support.PasswordPolicyConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.authentication.PasswordEncoderProperties;
import org.apereo.cas.configuration.model.core.authentication.PrincipalTransformationProperties;
import org.apereo.cas.configuration.model.support.jdbc.JdbcAuthenticationProperties;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="casJdbcConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasJdbcConfiguration {
    @Autowired(required=false)
    @Qualifier(value="queryAndEncodePasswordPolicyConfiguration")
    private PasswordPolicyConfiguration queryAndEncodePasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="searchModePasswordPolicyConfiguration")
    private PasswordPolicyConfiguration searchModePasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="queryPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration queryPasswordPolicyConfiguration;
    @Autowired(required=false)
    @Qualifier(value="bindSearchPasswordPolicyConfiguration")
    private PasswordPolicyConfiguration bindSearchPasswordPolicyConfiguration;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;

    @PostConstruct
    public void initializeJdbcAuthenticationHandlers() {
        this.casProperties.getAuthn().getJdbc().getBind().forEach(b -> this.authenticationHandlersResolvers.put(this.bindModeSearchDatabaseAuthenticationHandler((JdbcAuthenticationProperties.Bind)b), this.personDirectoryPrincipalResolver));
        this.casProperties.getAuthn().getJdbc().getEncode().forEach(b -> this.authenticationHandlersResolvers.put(this.queryAndEncodeDatabaseAuthenticationHandler((JdbcAuthenticationProperties.Encode)b), this.personDirectoryPrincipalResolver));
        this.casProperties.getAuthn().getJdbc().getQuery().forEach(b -> this.authenticationHandlersResolvers.put(this.queryDatabaseAuthenticationHandler((JdbcAuthenticationProperties.Query)b), this.personDirectoryPrincipalResolver));
        this.casProperties.getAuthn().getJdbc().getSearch().forEach(b -> this.authenticationHandlersResolvers.put(this.searchModeSearchDatabaseAuthenticationHandler((JdbcAuthenticationProperties.Search)b), this.personDirectoryPrincipalResolver));
    }

    private AuthenticationHandler bindModeSearchDatabaseAuthenticationHandler(JdbcAuthenticationProperties.Bind b) {
        BindModeSearchDatabaseAuthenticationHandler h = new BindModeSearchDatabaseAuthenticationHandler();
        h.setDataSource((DataSource)Beans.newHickariDataSource((AbstractJpaProperties)b));
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.bindSearchPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.bindSearchPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        h.setPrincipalFactory(this.jdbcPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(credential -> Predicates.containsPattern((String)b.getCredentialCriteria()).apply((Object)credential.getId()));
        }
        return h;
    }

    private AuthenticationHandler queryAndEncodeDatabaseAuthenticationHandler(JdbcAuthenticationProperties.Encode b) {
        QueryAndEncodeDatabaseAuthenticationHandler h = new QueryAndEncodeDatabaseAuthenticationHandler();
        h.setAlgorithmName(b.getAlgorithmName());
        h.setNumberOfIterationsFieldName(b.getNumberOfIterationsFieldName());
        h.setNumberOfIterations(b.getNumberOfIterations());
        h.setPasswordFieldName(b.getPasswordFieldName());
        h.setSaltFieldName(b.getSaltFieldName());
        h.setSql(b.getSql());
        h.setStaticSalt(b.getStaticSalt());
        h.setDataSource((DataSource)Beans.newHickariDataSource((AbstractJpaProperties)b));
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.queryAndEncodePasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.queryAndEncodePasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        h.setPrincipalFactory(this.jdbcPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(credential -> Predicates.containsPattern((String)b.getCredentialCriteria()).apply((Object)credential.getId()));
        }
        return h;
    }

    private AuthenticationHandler queryDatabaseAuthenticationHandler(JdbcAuthenticationProperties.Query b) {
        QueryDatabaseAuthenticationHandler h = new QueryDatabaseAuthenticationHandler();
        h.setDataSource((DataSource)Beans.newHickariDataSource((AbstractJpaProperties)b));
        h.setSql(b.getSql());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.queryPasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.queryPasswordPolicyConfiguration);
        }
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        h.setPrincipalFactory(this.jdbcPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(credential -> Predicates.containsPattern((String)b.getCredentialCriteria()).apply((Object)credential.getId()));
        }
        return h;
    }

    private AuthenticationHandler searchModeSearchDatabaseAuthenticationHandler(JdbcAuthenticationProperties.Search b) {
        SearchModeSearchDatabaseAuthenticationHandler h = new SearchModeSearchDatabaseAuthenticationHandler();
        h.setDataSource((DataSource)Beans.newHickariDataSource((AbstractJpaProperties)b));
        h.setFieldPassword(b.getFieldPassword());
        h.setFieldUser(b.getFieldUser());
        h.setTableUsers(b.getTableUsers());
        h.setPasswordEncoder(Beans.newPasswordEncoder((PasswordEncoderProperties)b.getPasswordEncoder()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        h.setPrincipalNameTransformer(Beans.newPrincipalNameTransformer((PrincipalTransformationProperties)b.getPrincipalTransformation()));
        if (this.searchModePasswordPolicyConfiguration != null) {
            h.setPasswordPolicyConfiguration(this.searchModePasswordPolicyConfiguration);
        }
        h.setPrincipalFactory(this.jdbcPrincipalFactory());
        h.setServicesManager(this.servicesManager);
        if (StringUtils.isNotBlank((CharSequence)b.getCredentialCriteria())) {
            h.setCredentialSelectionPredicate(credential -> Predicates.containsPattern((String)b.getCredentialCriteria()).apply((Object)credential.getId()));
        }
        return h;
    }

    @Bean
    public PrincipalFactory jdbcPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }
}

