/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.HandlerResult;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.UsernamePasswordCredential;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.support.LdapPasswordPolicyConfiguration;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;

public class LdapAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    private static final String LDAP_ATTRIBUTE_ENTRY_DN = LdapAuthenticationHandler.class.getSimpleName().concat(".dn");
    protected Map<String, String> principalAttributeMap = Collections.emptyMap();
    protected List<String> additionalAttributes = Collections.emptyList();
    private Authenticator authenticator;
    private String name = LdapAuthenticationHandler.class.getSimpleName();
    private String principalIdAttribute;
    private boolean allowMultiplePrincipalAttributeValues;
    private String[] authenticatedEntryAttributes = ReturnAttributes.NONE.value();

    public LdapAuthenticationHandler() {
    }

    public LdapAuthenticationHandler(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPrincipalIdAttribute(String attributeName) {
        this.principalIdAttribute = attributeName;
    }

    public void setAllowMultiplePrincipalAttributeValues(boolean allowed) {
        this.allowMultiplePrincipalAttributeValues = allowed;
    }

    public void setPrincipalAttributeMap(Map<String, String> attributeNameMap) {
        this.principalAttributeMap = attributeNameMap;
    }

    public void setPrincipalAttributeList(List<String> attributeList) {
        this.principalAttributeMap = Maps.uniqueIndex(attributeList, (Function)Functions.toStringFunction());
    }

    public void setAdditionalAttributes(List<String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    protected HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential upc) throws GeneralSecurityException, PreventedException {
        List messageList;
        AuthenticationResponse response;
        try {
            this.logger.debug("Attempting LDAP authentication for {}", (Object)upc);
            AuthenticationRequest request = new AuthenticationRequest(upc.getUsername(), new org.ldaptive.Credential(upc.getPassword()), this.authenticatedEntryAttributes);
            response = this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            this.logger.trace(e.getMessage(), (Throwable)e);
            throw new PreventedException("Unexpected LDAP error", (Throwable)e);
        }
        this.logger.debug("LDAP response: {}", (Object)response);
        LdapPasswordPolicyConfiguration ldapPasswordPolicyConfiguration = (LdapPasswordPolicyConfiguration)super.getPasswordPolicyConfiguration();
        if (ldapPasswordPolicyConfiguration != null) {
            this.logger.debug("Applying password policy to {}", (Object)response);
            messageList = ldapPasswordPolicyConfiguration.getAccountStateHandler().handle(response, ldapPasswordPolicyConfiguration);
        } else {
            this.logger.debug("No ldap password policy configuration is defined");
            messageList = Collections.emptyList();
        }
        if (((Boolean)response.getResult()).booleanValue()) {
            this.logger.debug("LDAP response returned as result. Creating the final LDAP principal");
            return this.createHandlerResult((Credential)upc, this.createPrincipal(upc.getUsername(), response.getLdapEntry()), messageList);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode()) {
            this.logger.warn("DN resolution failed. {}", (Object)response.getMessage());
            throw new AccountNotFoundException(upc.getUsername() + " not found.");
        }
        throw new FailedLoginException("Invalid credentials");
    }

    public String getName() {
        return this.name;
    }

    protected Principal createPrincipal(String username, LdapEntry ldapEntry) throws LoginException {
        this.logger.debug("Creating LDAP principal for {} based on {}", (Object)username, (Object)ldapEntry.getDn());
        String id = this.getLdapPrincipalIdentifier(username, ldapEntry);
        LinkedHashMap<String, Object> attributeMap = new LinkedHashMap<String, Object>(this.principalAttributeMap.size());
        for (Map.Entry<String, String> ldapAttr : this.principalAttributeMap.entrySet()) {
            LdapAttribute attr = ldapEntry.getAttribute(ldapAttr.getKey());
            if (attr == null) continue;
            this.logger.debug("Found principal attribute: {}", (Object)attr);
            String principalAttrName = ldapAttr.getValue();
            if (attr.size() > 1) {
                this.logger.debug("Principal attribute: {} is multivalued", (Object)attr);
                attributeMap.put(principalAttrName, attr.getStringValues());
                continue;
            }
            attributeMap.put(principalAttrName, attr.getStringValue());
        }
        attributeMap.put(LDAP_ATTRIBUTE_ENTRY_DN, ldapEntry.getDn());
        this.logger.debug("Created LDAP principal for id {} and {} attributes", (Object)id, (Object)attributeMap.size());
        return this.principalFactory.createPrincipal(id, attributeMap);
    }

    protected String getLdapPrincipalIdentifier(String username, LdapEntry ldapEntry) throws LoginException {
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            LdapAttribute principalAttr = ldapEntry.getAttribute(this.principalIdAttribute);
            if (principalAttr == null || principalAttr.size() == 0) {
                this.logger.warn("The principal id attribute [{}] is not found. CAS cannot construct the final authenticated principal if it's unable to locate the attribute that is designated as the principal id. Attributes available on the LDAP entry are [{}]. Since principal id attribute is not available, CAS will fallback to construct the principal based on the provided user id: {}", new Object[]{this.principalIdAttribute, ldapEntry.getAttributes(), username});
                return username;
            }
            if (principalAttr.size() > 1) {
                if (!this.allowMultiplePrincipalAttributeValues) {
                    throw new LoginException("Multiple principal values are not allowed: " + principalAttr);
                }
                this.logger.warn("Found multiple values for principal id attribute: {}. Using first value={}.", (Object)principalAttr, (Object)principalAttr.getStringValue());
            }
            this.logger.debug("Retrieved principal id attribute {}", (Object)principalAttr.getStringValue());
            return principalAttr.getStringValue();
        }
        this.logger.debug("Principal id attribute is not defined. Using the default provided user id {}", (Object)username);
        return username;
    }

    @PostConstruct
    public void initialize() {
        HashSet<String> attributes = new HashSet<String>();
        this.logger.debug("Initializing LDAP attribute configuration...");
        if (StringUtils.isNotBlank((CharSequence)this.principalIdAttribute)) {
            this.logger.debug("Configured to retrieve principal id attribute {}", (Object)this.principalIdAttribute);
            attributes.add(this.principalIdAttribute);
        }
        if (this.principalAttributeMap != null && !this.principalAttributeMap.isEmpty()) {
            Set<String> attrs = this.principalAttributeMap.keySet();
            attributes.addAll(attrs);
            this.logger.debug("Configured to retrieve principal attribute collection of {}", attrs);
        }
        if (this.additionalAttributes != null && !this.additionalAttributes.isEmpty()) {
            attributes.addAll(this.additionalAttributes);
            this.logger.debug("Configured to retrieve additional attributes {}", this.additionalAttributes);
        }
        if (!attributes.isEmpty()) {
            this.authenticatedEntryAttributes = attributes.toArray(new String[attributes.size()]);
        }
        this.logger.debug("LDAP authentication entry attributes are {}", (Object[])this.authenticatedEntryAttributes);
    }
}

