/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.metrics.MetricsProperties;
import org.apereo.cas.configuration.model.support.influxdb.InfluxDbProperties;
import org.apereo.cas.configuration.model.support.mongo.BaseMongoDbProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.influxdb.InfluxDbConnectionFactory;
import org.apereo.cas.metrics.MongoDbMetric;
import org.apereo.cas.mongo.MongoDbConnectionFactory;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ExportMetricWriter;
import org.springframework.boot.actuate.metrics.opentsdb.OpenTsdbGaugeWriter;
import org.springframework.boot.actuate.metrics.repository.redis.RedisMetricRepository;
import org.springframework.boot.actuate.metrics.statsd.StatsdMetricWriter;
import org.springframework.boot.actuate.metrics.writer.GaugeWriter;
import org.springframework.boot.actuate.metrics.writer.MetricWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration(value="casMetricsRepositoryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasMetricsRepositoryConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasMetricsRepositoryConfiguration.class);
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnProperty(prefix="cas.metrics.redis", name={"prefix"})
    @Bean
    @ExportMetricWriter
    public MetricWriter redisMetricWriter() {
        MetricsProperties.Redis redis = this.casProperties.getMetrics().getRedis();
        RedisObjectFactory factory = new RedisObjectFactory();
        RedisConnectionFactory connectionFactory = factory.newRedisConnectionFactory((BaseRedisProperties)redis);
        return new RedisMetricRepository(connectionFactory, redis.getPrefix(), redis.getKey());
    }

    @ConditionalOnProperty(prefix="cas.metrics.openTsdb", name={"url"})
    @Bean
    @ExportMetricWriter
    public GaugeWriter openTsdbMetricWriter() {
        MetricsProperties.OpenTsdb prop = this.casProperties.getMetrics().getOpenTsdb();
        OpenTsdbGaugeWriter w = new OpenTsdbGaugeWriter(prop.getConnectTimeout(), prop.getReadTimeout());
        w.setUrl(prop.getUrl());
        return w;
    }

    @ConditionalOnProperty(prefix="cas.metrics.statsd", name={"host"})
    @Bean
    @ExportMetricWriter
    public MetricWriter statsdMetricWriter() {
        MetricsProperties.Statsd prop = this.casProperties.getMetrics().getStatsd();
        return new StatsdMetricWriter(prop.getPrefix(), prop.getHost(), prop.getPort());
    }

    @ConditionalOnProperty(prefix="cas.metrics.influxDb", name={"url"})
    @Bean
    @ExportMetricWriter
    public GaugeWriter influxDbMetricsWriter() {
        MetricsProperties.InfluxDb influxDb = this.casProperties.getMetrics().getInfluxDb();
        InfluxDbConnectionFactory factory = new InfluxDbConnectionFactory((InfluxDbProperties)influxDb);
        return value -> {
            Point point = Point.measurement((String)value.getName()).time(value.getTimestamp().getTime(), TimeUnit.MILLISECONDS).addField("value", value.getValue()).addField("name", value.getName()).tag("type", value.getClass().getSimpleName()).build();
            factory.write(point, influxDb.getDatabase());
        };
    }

    @ConditionalOnProperty(prefix="cas.metrics.mongo", name={"collection"})
    @Bean
    @ExportMetricWriter
    public GaugeWriter mongoDbMetricWriter() {
        MetricsProperties.MongoDb prop = this.casProperties.getMetrics().getMongo();
        MongoDbConnectionFactory factory = new MongoDbConnectionFactory();
        MongoTemplate mongoTemplate = factory.buildMongoTemplate((BaseMongoDbProperties)prop);
        return metric -> {
            MongoDbMetric metrics = new MongoDbMetric(metric);
            mongoTemplate.save((Object)metrics, prop.getCollection());
        };
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }
}

