/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.rest.resources;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.DefaultAuthenticationResultBuilder;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.rest.BadRestRequestException;
import org.apereo.cas.rest.factory.RestHttpRequestCredentialFactory;
import org.apereo.cas.rest.factory.ServiceTicketResourceEntityResponseFactory;
import org.apereo.cas.support.rest.resources.RestResourceUtils;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="serviceTicketResourceRestController")
public class ServiceTicketResource {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceTicketResource.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final TicketRegistrySupport ticketRegistrySupport;
    private final ArgumentExtractor argumentExtractor;
    private final ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory;
    private final RestHttpRequestCredentialFactory credentialFactory;
    private final ApplicationContext applicationContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/v1/tickets/{tgtId:.+}"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<String> createServiceTicket(HttpServletRequest httpServletRequest, @RequestBody(required=false) MultiValueMap<String, String> requestBody, @PathVariable(value="tgtId") String tgtId) {
        ResponseEntity responseEntity;
        try {
            Authentication authn = this.ticketRegistrySupport.getAuthenticationFrom(tgtId);
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)authn);
            if (authn == null) {
                throw new InvalidTicketException(tgtId);
            }
            WebApplicationService service = this.argumentExtractor.extractService(httpServletRequest);
            if (service == null) {
                throw new IllegalArgumentException("Target service/application is unspecified or unrecognized in the request");
            }
            if (BooleanUtils.toBoolean((String)httpServletRequest.getParameter("renew"))) {
                List credential = this.credentialFactory.fromRequest(httpServletRequest, requestBody);
                if (credential == null || credential.isEmpty()) {
                    throw new BadRestRequestException("No credentials are provided or extracted to authenticate the REST request");
                }
                AuthenticationResult authenticationResult = this.authenticationSystemSupport.handleAndFinalizeSingleAuthenticationTransaction((Service)service, (Collection)credential);
                ResponseEntity responseEntity2 = this.serviceTicketResourceEntityResponseFactory.build(tgtId, (Service)service, authenticationResult);
                return responseEntity2;
            }
            DefaultAuthenticationResultBuilder builder = new DefaultAuthenticationResultBuilder();
            AuthenticationResult authenticationResult = builder.collect(authn).build(this.authenticationSystemSupport.getPrincipalElectionStrategy(), (Service)service);
            ResponseEntity responseEntity3 = this.serviceTicketResourceEntityResponseFactory.build(tgtId, (Service)service, authenticationResult);
            return responseEntity3;
        }
        catch (InvalidTicketException e) {
            responseEntity = new ResponseEntity((Object)(tgtId + " could not be found or is considered invalid"), HttpStatus.NOT_FOUND);
            return responseEntity;
        }
        catch (AuthenticationException e) {
            responseEntity = RestResourceUtils.createResponseEntityForAuthnFailure(e, httpServletRequest, this.applicationContext);
            return responseEntity;
        }
        catch (BadRestRequestException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            responseEntity = new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
            return responseEntity;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            responseEntity = new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
            return responseEntity;
        }
        finally {
            AuthenticationCredentialsThreadLocalBinder.clear();
        }
    }

    @Generated
    public ServiceTicketResource(AuthenticationSystemSupport authenticationSystemSupport, TicketRegistrySupport ticketRegistrySupport, ArgumentExtractor argumentExtractor, ServiceTicketResourceEntityResponseFactory serviceTicketResourceEntityResponseFactory, RestHttpRequestCredentialFactory credentialFactory, ApplicationContext applicationContext) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.ticketRegistrySupport = ticketRegistrySupport;
        this.argumentExtractor = argumentExtractor;
        this.serviceTicketResourceEntityResponseFactory = serviceTicketResourceEntityResponseFactory;
        this.credentialFactory = credentialFactory;
        this.applicationContext = applicationContext;
    }
}

