/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.ScriptingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.web.servlet.theme.AbstractThemeResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class ServiceThemeResolver
extends AbstractThemeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceThemeResolver.class);
    private final ServicesManager servicesManager;
    private final AuthenticationServiceSelectionPlan authenticationRequestServiceSelectionStrategies;
    private final ResourceLoader resourceLoader;
    private final Map<Pattern, String> overrides;

    public ServiceThemeResolver(ServicesManager servicesManager, Map<String, String> mobileOverrides, AuthenticationServiceSelectionPlan serviceSelectionStrategies, ResourceLoader resourceLoader) {
        this.servicesManager = servicesManager;
        this.authenticationRequestServiceSelectionStrategies = serviceSelectionStrategies;
        this.resourceLoader = resourceLoader;
        this.overrides = mobileOverrides.entrySet().stream().collect(Collectors.toMap(entry -> Pattern.compile((String)entry.getKey()), Map.Entry::getValue));
    }

    public String resolveThemeName(HttpServletRequest request) {
        if (this.servicesManager == null) {
            return this.getDefaultThemeName();
        }
        String userAgent = HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return this.getDefaultThemeName();
        }
        this.overrides.entrySet().stream().filter(entry -> ((Pattern)entry.getKey()).matcher(userAgent).matches()).findFirst().ifPresent(entry -> {
            request.setAttribute("isMobile", (Object)Boolean.TRUE.toString());
            request.setAttribute("browserType", entry.getValue());
        });
        RequestContext context = RequestContextHolder.getRequestContext();
        WebApplicationService serviceContext = WebUtils.getService((RequestContext)context);
        Service service = this.authenticationRequestServiceSelectionStrategies.resolveService((Service)serviceContext);
        if (service == null) {
            LOGGER.debug("No service is found in the request context. Falling back to the default theme [{}]", (Object)this.getDefaultThemeName());
            return this.getDefaultThemeName();
        }
        RegisteredService rService = this.servicesManager.findServiceBy(service);
        if (rService == null || !rService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("No registered service is found to match [{}] or service access is disallowed. Using default theme [{}]", (Object)service, (Object)this.getDefaultThemeName());
            return this.getDefaultThemeName();
        }
        if (StringUtils.isBlank((CharSequence)rService.getTheme())) {
            LOGGER.debug("No theme name is specified for service [{}]. Using default theme [{}]", (Object)rService, (Object)this.getDefaultThemeName());
            return this.getDefaultThemeName();
        }
        return this.determineThemeNameToChoose(request, service, rService);
    }

    protected String determineThemeNameToChoose(HttpServletRequest request, Service service, RegisteredService rService) {
        try {
            LOGGER.debug("Service [{}] is configured to use a custom theme [{}]", (Object)rService, (Object)rService.getTheme());
            AbstractResource resource = ResourceUtils.getRawResourceFrom((String)rService.getTheme());
            if (resource instanceof FileSystemResource && resource.exists()) {
                LOGGER.debug("Executing groovy script to determine theme for [{}]", (Object)service.getId());
                String result = (String)ScriptingUtils.executeGroovyScript((Resource)resource, (Object[])new Object[]{service, rService, request.getQueryString(), HttpRequestUtils.getRequestHeaders((HttpServletRequest)request), LOGGER}, String.class);
                return (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
            }
            if (resource instanceof UrlResource) {
                String url = resource.getURL().toExternalForm();
                LOGGER.debug("Executing URL [{}] to determine theme for [{}]", (Object)url, (Object)service.getId());
                HttpResponse response = HttpUtils.executeGet((String)url, (Map)CollectionUtils.wrap((String)"service", (Object)service.getId()));
                if (response != null && response.getStatusLine().getStatusCode() == 200) {
                    String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    return (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)this.getDefaultThemeName());
                }
            }
            CasThemeResourceBundleMessageSource messageSource = new CasThemeResourceBundleMessageSource();
            messageSource.setBasename(rService.getTheme());
            if (messageSource.doGetBundle(rService.getTheme(), request.getLocale()) != null) {
                LOGGER.debug("Found custom theme [{}] for service [{}]", (Object)rService.getTheme(), (Object)rService);
                return rService.getTheme();
            }
            LOGGER.warn("Custom theme [{}] for service [{}] cannot be located. Falling back to default theme...", (Object)rService.getTheme(), (Object)rService);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return this.getDefaultThemeName();
    }

    public void setThemeName(HttpServletRequest request, HttpServletResponse response, String themeName) {
    }

    private static class CasThemeResourceBundleMessageSource
    extends ResourceBundleMessageSource {
        private CasThemeResourceBundleMessageSource() {
        }

        protected ResourceBundle doGetBundle(String basename, Locale locale) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(basename, locale, this.getBundleClassLoader());
                if (bundle != null && !bundle.keySet().isEmpty()) {
                    return bundle;
                }
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }
}

