/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine;

import com.google.common.base.CaseFormat;
import com.google.common.base.Charsets;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.atteo.classindex.ClassFilter;
import org.atteo.classindex.ClassIndex;
import org.atteo.config.Configuration;
import org.atteo.config.IncorrectConfigurationException;
import org.atteo.config.XmlDefaultValue;
import org.atteo.config.XmlUtils;
import org.atteo.config.xmlmerge.CombineSelf;
import org.atteo.filtering.CompoundPropertyResolver;
import org.atteo.filtering.EnvironmentPropertyResolver;
import org.atteo.filtering.OneOfPropertyResolver;
import org.atteo.filtering.PropertyResolver;
import org.atteo.filtering.SystemPropertyResolver;
import org.atteo.filtering.XmlPropertyResolver;
import org.atteo.moonshine.Config;
import org.atteo.moonshine.ServiceConfiguration;
import org.atteo.moonshine.TopLevelService;
import org.atteo.moonshine.directories.FileAccessor;
import org.atteo.moonshine.services.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigurationReader {
    public static final String SCHEMA_FILE_NAME = "schema.xsd";
    public static final String CONFIG_FILE_NAME = "config.xml";
    public static final String AUTO_CONFIG_FILE_NAME = "auto-config.xml";
    public static final String DEFAULT_CONFIG_RESOURCE_NAME = "/default-config.xml";
    private final Configuration configuration = new Configuration();
    private final CompoundPropertyResolver customPropertyResolvers = new CompoundPropertyResolver(new PropertyResolver[0]);
    private PropertyResolver propertyResolver = null;
    private final FileAccessor fileAccessor;

    public ConfigurationReader(FileAccessor fileAccessor) {
        this.fileAccessor = fileAccessor;
    }

    public void filter() throws IncorrectConfigurationException {
        NodeList nodesList;
        Element propertiesElement = null;
        if (this.configuration.getRootElement() != null && (nodesList = this.configuration.getRootElement().getElementsByTagName("properties")).getLength() == 1) {
            propertiesElement = (Element)nodesList.item(0);
        }
        this.propertyResolver = new CompoundPropertyResolver(new PropertyResolver[]{new OneOfPropertyResolver(), new SystemPropertyResolver(), new EnvironmentPropertyResolver(), new XmlPropertyResolver(propertiesElement, false), this.customPropertyResolvers, new XmlPropertyResolver(this.configuration.getRootElement(), true)});
        this.configuration.filter(this.propertyResolver);
    }

    public Config read() throws IncorrectConfigurationException {
        return (Config)this.configuration.read(Config.class);
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void generateAutoConfiguration() throws IncorrectConfigurationException, IOException {
        Iterable services = ClassFilter.only().topLevel().withoutModifiers(1024).satisfying(new ClassFilter.Predicate(){

            public boolean matches(Class<?> type) {
                return TopLevelService.class.isAssignableFrom(type);
            }
        }).satisfying(new ClassFilter.Predicate(){

            public boolean matches(Class<?> type) {
                return !ConfigurationReader.containsRequiredFieldWithoutDefault(type);
            }
        }).satisfying(new ClassFilter.Predicate(){

            public boolean matches(Class<?> type) {
                ServiceConfiguration annotation = type.getAnnotation(ServiceConfiguration.class);
                return annotation == null || annotation.auto();
            }
        }).from(ClassIndex.getSubclasses(Service.class));
        StringBuilder builder = new StringBuilder();
        builder.append("<config xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"schema.xsd\">\n");
        for (Class service : services) {
            ServiceConfiguration annotation = service.getAnnotation(ServiceConfiguration.class);
            String name = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, service.getSimpleName());
            XmlRootElement xmlRootElement = service.getAnnotation(XmlRootElement.class);
            if (xmlRootElement != null && !"##default".equals(xmlRootElement.name())) {
                name = xmlRootElement.name();
            }
            builder.append("\t<").append(name);
            builder.append(" combine.self='").append(CombineSelf.OVERRIDABLE_BY_TAG.name().toLowerCase());
            if (annotation == null || annotation.autoConfiguration().isEmpty()) {
                builder.append("'/>\n");
                continue;
            }
            builder.append("'>\n");
            builder.append(annotation.autoConfiguration());
            builder.append("\n</").append(name).append(">\n");
        }
        builder.append("</config>\n");
        Path autoConfigPath = this.fileAccessor.getWritableConfigFile(AUTO_CONFIG_FILE_NAME);
        try (BufferedWriter writer = Files.newBufferedWriter(autoConfigPath, Charsets.UTF_8, new OpenOption[0]);){
            writer.write(builder.toString());
        }
    }

    public void removeAutoConfiguration() throws IOException {
        Path autoConfigPath = this.fileAccessor.getWritableConfigFile(AUTO_CONFIG_FILE_NAME);
        Files.deleteIfExists(autoConfigPath);
    }

    public void combineAutoConfiguration() throws IncorrectConfigurationException, IOException {
        Path path = this.fileAccessor.getConfigFile(AUTO_CONFIG_FILE_NAME);
        try (InputStream stream = Files.newInputStream(path, StandardOpenOption.READ);){
            this.combineConfigurationFromStream(stream);
        }
    }

    public void combineDefaultConfiguration() {
        try {
            this.combineConfigurationFromResource(DEFAULT_CONFIG_RESOURCE_NAME, false);
        }
        catch (IOException | IncorrectConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void combineConfigDirConfiguration() throws IncorrectConfigurationException, IOException {
        for (Path path : this.fileAccessor.getConfigFiles(CONFIG_FILE_NAME)) {
            InputStream stream = Files.newInputStream(path, StandardOpenOption.READ);
            Throwable throwable = null;
            try {
                this.combineConfigurationFromStream(stream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                stream.close();
            }
        }
    }

    public void combineConfigurationFromResource(String resourcePath, boolean throwIfNotFound) throws IncorrectConfigurationException, IOException {
        try (InputStream stream = this.getClass().getResourceAsStream(resourcePath);){
            if (stream != null) {
                this.configuration.combine(stream);
            } else if (throwIfNotFound) {
                throw new RuntimeException("Configuration resource not found: " + resourcePath);
            }
        }
    }

    public void combineConfigurationFromStream(InputStream stream) throws IncorrectConfigurationException, IOException {
        this.configuration.combine(stream);
    }

    public void combineConfigurationFromFile(File file, boolean throwIfNotFound) throws IncorrectConfigurationException, IOException {
        if (!file.exists()) {
            if (throwIfNotFound) {
                throw new RuntimeException("Configuration file not found: " + file.getAbsolutePath());
            }
            return;
        }
        try (FileInputStream stream = new FileInputStream(file);){
            this.configuration.combine((InputStream)stream);
        }
    }

    public void combineConfigurationFromString(String string) throws IncorrectConfigurationException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes(Charsets.UTF_8));){
            this.configuration.combine((InputStream)stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String printCombinedXml() {
        return XmlUtils.prettyPrint((Node)this.configuration.getRootElement());
    }

    public void addCustomPropertyResolver(PropertyResolver resolver) {
        this.customPropertyResolvers.addPropertyResolver(resolver);
    }

    public void generateTemplateConfigurationFile() throws FileNotFoundException, IOException {
        Path schemaPath = this.fileAccessor.getWritableConfigFile(SCHEMA_FILE_NAME);
        Files.createDirectories(schemaPath.getParent(), new FileAttribute[0]);
        this.configuration.generateSchema(schemaPath.toFile());
        Path configPath = this.fileAccessor.getWritableConfigFile(CONFIG_FILE_NAME);
        if (Files.exists(configPath, new LinkOption[0])) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, Charsets.UTF_8, new OpenOption[0]);){
            writer.append("<config xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"schema.xsd\">\n</config>\n");
        }
    }

    private static boolean containsRequiredFieldWithoutDefault(Class<?> type) {
        while (type != Object.class) {
            for (Field field : type.getDeclaredFields()) {
                if (field.isAnnotationPresent(XmlDefaultValue.class)) continue;
                XmlElement annotation = field.getAnnotation(XmlElement.class);
                XmlAttribute annotation2 = field.getAnnotation(XmlAttribute.class);
                if (annotation != null && annotation.required()) {
                    return true;
                }
                if (annotation2 == null || !annotation2.required()) continue;
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }
}

