/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import javax.annotation.Nullable;
import org.atteo.filtering.PropertyResolver;
import org.atteo.moonshine.CommandLineParameterException;
import org.atteo.moonshine.ConfigurationException;
import org.atteo.moonshine.MoonshineException;
import org.atteo.moonshine.MoonshineImplementation;
import org.atteo.moonshine.ParameterProcessor;
import org.atteo.moonshine.logging.Logging;
import org.atteo.moonshine.services.LifeCycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Moonshine
extends AutoCloseable {
    public void start();

    public void stop();

    public Injector getGlobalInjector();

    @Override
    public void close();

    public static class Factory {
        public static Builder builder() {
            return new MoonshineImplementation();
        }

        public static void logException(MoonshineException e) {
            Logger logger = LoggerFactory.getLogger((String)"Moonshine");
            if (e instanceof ConfigurationException) {
                logger.error("Incorrect configuration file: " + e.getMessage());
                logger.debug("Incorrect configuration file", (Throwable)e);
            } else if (e instanceof CommandLineParameterException) {
                logger.error(e.getMessage());
                logger.debug(e.getMessage(), (Throwable)e);
            } else {
                logger.error("Fatal error: " + e.getMessage());
                logger.debug("Fatal error", (Throwable)e);
            }
        }
    }

    public static interface Builder
    extends RestrictedBuilder {
        public Builder applicationName(String var1);

        public Builder arguments(String[] var1);

        public Builder skipUncaughtExceptionHandler();

        public Builder addParameterProcessor(ParameterProcessor var1);

        @Override
        public Builder shutdownHook(boolean var1);

        public Builder loggingFramework(Logging var1);

        @Override
        public Builder homeDirectory(String var1);

        @Override
        public Builder autoConfiguration();

        @Override
        public Builder skipDefaultConfigurationFiles();

        @Override
        public Builder addConfigurationFromResource(String var1);

        @Override
        public Builder addOptionalConfigurationFromResource(String var1);

        @Override
        public Builder addModule(Module var1);

        @Override
        public Builder registerListener(LifeCycleListener var1);

        @Override
        public Builder addConfigurationFromString(String var1);

        @Override
        public Builder addPropertyResolver(PropertyResolver var1);

        @Override
        public Builder addConfigDir(String var1);

        @Override
        public Builder addDataDir(String var1);

        @Nullable
        public Moonshine build() throws MoonshineException, IOException;
    }

    public static interface RestrictedBuilder {
        public RestrictedBuilder shutdownHook(boolean var1);

        public RestrictedBuilder homeDirectory(String var1);

        public Builder autoConfiguration();

        public RestrictedBuilder skipDefaultConfigurationFiles();

        public RestrictedBuilder addConfigurationFromResource(String var1);

        public RestrictedBuilder addOptionalConfigurationFromResource(String var1);

        public RestrictedBuilder addModule(Module var1);

        public RestrictedBuilder registerListener(LifeCycleListener var1);

        public RestrictedBuilder addConfigurationFromString(String var1);

        public RestrictedBuilder addPropertyResolver(PropertyResolver var1);

        public RestrictedBuilder addConfigDir(String var1);

        public RestrictedBuilder addDataDir(String var1);
    }
}

