/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.atteo.config.IncorrectConfigurationException;
import org.atteo.filtering.Filtering;
import org.atteo.filtering.PropertiesPropertyResolver;
import org.atteo.filtering.PropertyFilter;
import org.atteo.filtering.PropertyResolver;
import org.atteo.moonshine.ApplicationProperties;
import org.atteo.moonshine.CommandLineParameterException;
import org.atteo.moonshine.Config;
import org.atteo.moonshine.ConfigurationException;
import org.atteo.moonshine.ConfigurationReader;
import org.atteo.moonshine.Moonshine;
import org.atteo.moonshine.MoonshineCommandLineParameters;
import org.atteo.moonshine.MoonshineException;
import org.atteo.moonshine.ParameterProcessor;
import org.atteo.moonshine.directories.DefaultFileAccessor;
import org.atteo.moonshine.directories.FileAccessor;
import org.atteo.moonshine.directories.FileAccessorFactory;
import org.atteo.moonshine.directories.SubdirectoryLayout;
import org.atteo.moonshine.logging.Logback;
import org.atteo.moonshine.logging.Logging;
import org.atteo.moonshine.services.LifeCycleListener;
import org.atteo.moonshine.services.Services;
import org.atteo.moonshine.services.internal.GuiceBindingsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MoonshineImplementation
implements Moonshine.Builder,
Moonshine {
    private final Thread shutdownThread = new Thread(){

        @Override
        public void run() {
            MoonshineImplementation.this.close();
        }
    };
    private final Logger logger = LoggerFactory.getLogger((String)"Moonshine");
    private Services services;
    private Logging logging;
    private FileAccessorFactory fileAccessorFactory;
    private String applicationName;
    private String[] arguments;
    private String homeDirectory;
    private final List<ParameterProcessor> parameterProcessors = new ArrayList<ParameterProcessor>();
    private final List<String> configurationResources = new ArrayList<String>();
    private final List<String> optionalConfigurationResources = new ArrayList<String>();
    private final List<String> configurationStrings = new ArrayList<String>();
    private final List<Module> modules = new ArrayList<Module>();
    private final List<LifeCycleListener> listeners = new ArrayList<LifeCycleListener>();
    private final List<PropertyResolver> propertyResolvers = new ArrayList<PropertyResolver>();
    private final List<String> configDirs = new ArrayList<String>();
    private final List<String> dataDirs = new ArrayList<String>();
    private boolean shutdownHook = true;
    private boolean autoConfiguration = false;
    private boolean skipDefaultConfigurationFile = false;
    private boolean skipExceptionHandler = false;

    MoonshineImplementation() {
    }

    @Override
    public Moonshine.Builder applicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Override
    public Moonshine.Builder skipUncaughtExceptionHandler() {
        this.skipExceptionHandler = true;
        return this;
    }

    @Override
    public Moonshine.Builder arguments(String[] arguments) {
        this.arguments = arguments;
        return this;
    }

    @Override
    public Moonshine.Builder shutdownHook(boolean shutdownHook) {
        this.shutdownHook = shutdownHook;
        return this;
    }

    @Override
    public Moonshine.Builder loggingFramework(Logging logging) {
        this.logging = logging;
        return this;
    }

    @Override
    public Moonshine.Builder addParameterProcessor(ParameterProcessor processor) {
        this.parameterProcessors.add(processor);
        return this;
    }

    @Override
    public Moonshine build() throws IOException, CommandLineParameterException, ConfigurationException {
        Config config;
        this.logger.info("Bootstrapping {}", (Object)(this.applicationName != null ? this.applicationName : "Moonshine"));
        if (!this.skipExceptionHandler) {
            Thread.currentThread().setUncaughtExceptionHandler(new MoonshineUncaughtExceptionHandler());
        }
        if (this.logging == null) {
            this.logging = new Logback();
        }
        this.logging.earlyBootstrap();
        this.fileAccessorFactory = new DefaultFileAccessor();
        JCommander commander = new JCommander();
        MoonshineCommandLineParameters moonshineParameters = new MoonshineCommandLineParameters();
        commander.setProgramName(this.applicationName);
        commander.addObject((Object)moonshineParameters);
        commander.addObject(this.logging.getParameters());
        commander.addObject(this.fileAccessorFactory.getParameters());
        for (ParameterProcessor object : this.parameterProcessors) {
            commander.addObject((Object)object);
        }
        if (this.arguments == null) {
            this.arguments = new String[0];
        }
        try {
            commander.parse(this.arguments);
        }
        catch (ParameterException e) {
            throw new CommandLineParameterException("Cannot parse command line parameters: " + e.getMessage(), e);
        }
        for (ParameterProcessor parameterProcessor : this.parameterProcessors) {
            parameterProcessor.configure(this);
        }
        Path homePath = this.homeDirectory == null ? Paths.get("", new String[0]) : Paths.get(this.homeDirectory, new String[0]);
        this.fileAccessorFactory.setWriteableLayout(new SubdirectoryLayout(homePath));
        for (String configDir : this.configDirs) {
            this.fileAccessorFactory.addConfigDir(configDir);
        }
        for (String dataDir : this.dataDirs) {
            this.fileAccessorFactory.addDataDir(dataDir);
        }
        if (this.applicationName == null) {
            this.applicationName = "moonshine";
        }
        if (moonshineParameters.isHelp()) {
            StringBuilder builder = new StringBuilder();
            commander.usage(builder);
            this.logger.info(builder.toString());
            return null;
        }
        FileAccessor fileAccessor = this.fileAccessorFactory.getFileAccessor();
        Properties fileAccessorProperties = fileAccessor.getProperties();
        fileAccessorProperties.setProperty("applicationName", this.applicationName);
        this.logging.initialize(fileAccessor, fileAccessorProperties);
        ConfigurationReader configuration = new ConfigurationReader(fileAccessor);
        try {
            this.setupConfiguration(moonshineParameters, configuration);
            configuration.addCustomPropertyResolver((PropertyResolver)new PropertiesPropertyResolver(fileAccessorProperties));
            Path configPropertiesFile = fileAccessor.getConfigFile("config.properties");
            if (configPropertiesFile != null) {
                Properties configProperties = new Properties();
                configProperties.load(Files.newBufferedReader(configPropertiesFile, StandardCharsets.UTF_8));
                configuration.addCustomPropertyResolver((PropertyResolver)new PropertiesPropertyResolver(configProperties));
            }
            if (moonshineParameters.isPrintConfig()) {
                this.logger.info("Configuration is:\n" + configuration.printCombinedXml());
                return null;
            }
            configuration.filter();
            if (moonshineParameters.isPrintFilteredConfig()) {
                this.logger.info("Filtered configuration is:\n" + configuration.printCombinedXml());
                return null;
            }
            config = configuration.read();
        }
        catch (IncorrectConfigurationException e) {
            throw new ConfigurationException(e.getMessage(), e);
        }
        final PropertyResolver propertyResolver = configuration.getPropertyResolver();
        this.modules.add((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Key.get(PropertyResolver.class, ApplicationProperties.class)).toInstance((Object)propertyResolver);
                this.bind(Key.get(PropertyFilter.class, ApplicationProperties.class)).toInstance((Object)Filtering.getFilter((PropertyResolver[])new PropertyResolver[]{propertyResolver}));
            }
        });
        Services.Builder builder = this.createServicesBuilder();
        for (Module module : this.modules) {
            builder.addModule(module);
        }
        for (LifeCycleListener listener : this.listeners) {
            builder.registerListener(listener);
        }
        builder.configuration(config);
        this.services = builder.build();
        if (moonshineParameters.isPrintGuiceBindings()) {
            GuiceBindingsHelper.printServiceElements(this.services.getServiceElements());
        }
        if (this.shutdownHook) {
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        }
        return this;
    }

    @Override
    public Moonshine.Builder homeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        return this;
    }

    @Override
    public Moonshine.Builder addConfigDir(String path) {
        this.dataDirs.add(path);
        return this;
    }

    @Override
    public Moonshine.Builder addDataDir(String path) {
        this.configDirs.add(path);
        return this;
    }

    @Override
    public Moonshine.Builder autoConfiguration() {
        this.autoConfiguration = true;
        return this;
    }

    @Override
    public Moonshine.Builder skipDefaultConfigurationFiles() {
        this.skipDefaultConfigurationFile = true;
        return this;
    }

    @Override
    public Moonshine.Builder addConfigurationFromResource(String resource) {
        this.configurationResources.add(resource);
        return this;
    }

    @Override
    public Moonshine.Builder addOptionalConfigurationFromResource(String resource) {
        this.optionalConfigurationResources.add(resource);
        return this;
    }

    @Override
    public Moonshine.Builder addConfigurationFromString(String string) {
        this.configurationStrings.add(string);
        return this;
    }

    @Override
    public Moonshine.Builder addModule(Module module) {
        this.modules.add(module);
        return this;
    }

    @Override
    public Moonshine.Builder registerListener(LifeCycleListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Moonshine.Builder addPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolvers.add(propertyResolver);
        return this;
    }

    protected Services.Builder createServicesBuilder() {
        return Services.Factory.builder();
    }

    @Override
    public void start() {
        this.services.start();
    }

    @Override
    public void stop() {
        this.services.stop();
    }

    @Override
    public void close() {
        this.logger.info("Shutting down {}", (Object)(this.applicationName != null ? this.applicationName : "Moonshine"));
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.services != null) {
            this.services.close();
            this.services = null;
        }
    }

    @Override
    public Injector getGlobalInjector() {
        return this.services.getGlobalInjector();
    }

    protected void setupConfiguration(MoonshineCommandLineParameters moonshineParameters, ConfigurationReader configuration) throws IOException, IncorrectConfigurationException {
        if (this.autoConfiguration || moonshineParameters.isAutoConfiguration()) {
            configuration.generateAutoConfiguration();
            configuration.combineAutoConfiguration();
        } else {
            configuration.removeAutoConfiguration();
        }
        if (!this.skipDefaultConfigurationFile && !moonshineParameters.isNoDefaults()) {
            configuration.combineDefaultConfiguration();
        }
        for (String resource : this.configurationResources) {
            configuration.combineConfigurationFromResource(resource, true);
        }
        for (String resource : this.optionalConfigurationResources) {
            configuration.combineConfigurationFromResource(resource, false);
        }
        for (String string : this.configurationStrings) {
            configuration.combineConfigurationFromString(string);
        }
        if (moonshineParameters.getConfigurationFiles().isEmpty()) {
            configuration.combineConfigDirConfiguration();
        } else {
            for (String fileName : moonshineParameters.getConfigurationFiles()) {
                configuration.combineConfigurationFromFile(new File(fileName), true);
            }
        }
        configuration.generateTemplateConfigurationFile();
        for (PropertyResolver resolver : this.propertyResolvers) {
            configuration.addCustomPropertyResolver(resolver);
        }
    }

    private static class MoonshineUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private MoonshineUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof MoonshineException) {
                Moonshine.Factory.logException((MoonshineException)e);
            } else {
                Logger logger = LoggerFactory.getLogger((String)"Moonshine");
                logger.error("Fatal error: " + e.getMessage(), e);
            }
        }
    }
}

