/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine;

import com.google.inject.Injector;
import com.google.inject.servlet.GuiceServletContextListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.atteo.filtering.PropertiesPropertyResolver;
import org.atteo.filtering.PropertyResolver;
import org.atteo.moonshine.Moonshine;
import org.atteo.moonshine.MoonshineException;

public class MoonshineServletContextListener
extends GuiceServletContextListener {
    private Moonshine moonshine;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            Moonshine.Builder builder = Moonshine.Factory.builder();
            this.configure(builder, servletContext);
            this.moonshine = builder.build();
            if (this.moonshine != null) {
                this.moonshine.start();
            }
        }
        catch (IOException | MoonshineException e) {
            throw new RuntimeException(e);
        }
        super.contextInitialized(servletContextEvent);
    }

    protected void configure(Moonshine.Builder builder, ServletContext servletContext) {
        builder.applicationName(servletContext.getServletContextName()).shutdownHook(false).addPropertyResolver(MoonshineServletContextListener.retrieveContextParameters(servletContext));
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        if (this.moonshine != null) {
            this.moonshine.close();
        }
    }

    protected Injector getInjector() {
        return this.moonshine.getGlobalInjector();
    }

    private static PropertyResolver retrieveContextParameters(ServletContext servletContext) {
        Properties properties = new Properties();
        Enumeration initParameterNames = servletContext.getInitParameterNames();
        while (initParameterNames.hasMoreElements()) {
            String name = (String)initParameterNames.nextElement();
            properties.put(name, servletContext.getInitParameter(name));
        }
        return new PropertiesPropertyResolver(properties);
    }
}

