/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.directories;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.atteo.moonshine.directories.FileAccessor;
import org.atteo.moonshine.directories.FileAccessorCommandLineParameters;
import org.atteo.moonshine.directories.FileAccessorFactory;
import org.atteo.moonshine.directories.ReadOnlyDirectoryLayout;
import org.atteo.moonshine.directories.SubdirectoryLayout;
import org.atteo.moonshine.directories.WriteableDirectoryLayout;

public class DefaultFileAccessor
implements FileAccessorFactory {
    private FileAccessorCommandLineParameters parameters = new FileAccessorCommandLineParameters();
    private WriteableDirectoryLayout writeableLayout;
    private List<ReadOnlyDirectoryLayout> readOnlyLayouts = new ArrayList<ReadOnlyDirectoryLayout>();
    private List<Path> extraConfigDirs = new ArrayList<Path>();
    private List<Path> extraDataDirs = new ArrayList<Path>();

    @Override
    public Object getParameters() {
        return this.parameters;
    }

    @Override
    public void addConfigDir(String path) {
        this.extraConfigDirs.add(Paths.get(path, new String[0]));
    }

    @Override
    public void addDataDir(String path) {
        this.extraDataDirs.add(Paths.get(path, new String[0]));
    }

    @Override
    public void setWriteableLayout(WriteableDirectoryLayout writeableLayout) {
        this.writeableLayout = writeableLayout;
    }

    @Override
    public FileAccessor getFileAccessor() throws IOException {
        final ArrayList configDirs = new ArrayList();
        final ArrayList dataDirs = new ArrayList();
        WriteableDirectoryLayout layout = this.writeableLayout;
        if (this.parameters.getHomeDirectory() != null) {
            layout = new SubdirectoryLayout(Paths.get(this.parameters.getHomeDirectory(), new String[0]));
        }
        if (layout == null) {
            layout = new SubdirectoryLayout(Paths.get("", new String[0]));
        }
        final Path configHome = this.parameters.getConfigHome() != null ? Paths.get(this.parameters.getConfigHome(), new String[0]) : layout.getConfigHome();
        final Path dataHome = this.parameters.getDataHome() != null ? Paths.get(this.parameters.getDataHome(), new String[0]) : layout.getDataHome();
        final Path cacheHome = this.parameters.getCacheHome() != null ? Paths.get(this.parameters.getCacheHome(), new String[0]) : layout.getCacheHome();
        final Path logHome = this.parameters.getLogHome() != null ? Paths.get(this.parameters.getLogHome(), new String[0]) : layout.getLogHome();
        Iterables.addAll(configDirs, layout.getConfigDirs());
        Iterables.addAll(dataDirs, layout.getDataDirs());
        Iterables.addAll(configDirs, this.extraConfigDirs);
        Iterables.addAll(dataDirs, this.extraDataDirs);
        for (ReadOnlyDirectoryLayout readOnlyLayout : this.readOnlyLayouts) {
            Iterables.addAll(configDirs, readOnlyLayout.getConfigDirs());
            Iterables.addAll(dataDirs, readOnlyLayout.getDataDirs());
        }
        Files.createDirectories(configHome, new FileAttribute[0]);
        Files.createDirectories(dataHome, new FileAttribute[0]);
        Files.createDirectories(cacheHome, new FileAttribute[0]);
        Files.createDirectories(logHome, new FileAttribute[0]);
        return new FileAccessor(){

            private Path getFile(Path home, Iterable<Path> dirs, String fileName) {
                Path filePath = home.resolve(fileName);
                if (Files.exists(filePath, new LinkOption[0])) {
                    return filePath;
                }
                for (Path path : dirs) {
                    filePath = path.resolve(fileName);
                    if (!Files.exists(filePath, new LinkOption[0])) continue;
                    return filePath;
                }
                return null;
            }

            private Iterable<Path> getFiles(Path home, Iterable<Path> dirs, String fileName) {
                ArrayList<Path> files = new ArrayList<Path>();
                Path filePath = home.resolve(fileName);
                if (Files.exists(filePath, new LinkOption[0])) {
                    files.add(filePath);
                }
                for (Path path : dirs) {
                    filePath = path.resolve(fileName);
                    if (!Files.exists(filePath, new LinkOption[0])) continue;
                    files.add(filePath);
                }
                return files;
            }

            @Override
            public Path getConfigFile(String fileName) {
                return this.getFile(configHome, configDirs, fileName);
            }

            @Override
            public Iterable<Path> getConfigFiles(String fileName) {
                return this.getFiles(configHome, configDirs, fileName);
            }

            @Override
            public Path getWritableConfigFile(String fileName) {
                return configHome.resolve(fileName);
            }

            @Override
            public Path getDataFile(String fileName) {
                return this.getFile(dataHome, dataDirs, fileName);
            }

            @Override
            public Iterable<Path> getDataFiles(String fileName) {
                return this.getFiles(configHome, configDirs, fileName);
            }

            @Override
            public Path getWriteableDataFile(String fileName) {
                return dataHome.resolve(fileName);
            }

            @Override
            public Path getWriteableCacheFile(String fileName) {
                return cacheHome.resolve(fileName);
            }

            @Override
            public Path getWriteableLogfile(String fileName) {
                return logHome.resolve(fileName);
            }

            @Override
            public Properties getProperties() {
                Properties properties = new Properties();
                properties.setProperty("configHome", configHome.toAbsolutePath().toString());
                properties.setProperty("dataHome", dataHome.toAbsolutePath().toString());
                properties.setProperty("cacheHome", cacheHome.toAbsolutePath().toString());
                properties.setProperty("logHome", logHome.toAbsolutePath().toString());
                return properties;
            }
        };
    }
}

