/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.directories;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.atteo.moonshine.directories.WriteableDirectoryLayout;

public class XdgDirectoryLayout
implements WriteableDirectoryLayout {
    private final Path homeDirectory;
    private final Path configHome;
    private final Path dataHome;
    private final Path cacheHome;
    private final List<Path> configDirs = new ArrayList<Path>();
    private final List<Path> dataDirs = new ArrayList<Path>();

    public XdgDirectoryLayout(String applicationName) {
        this.homeDirectory = Paths.get(System.getProperty("user.home"), new String[0]);
        String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
        this.configHome = xdgConfigHome != null ? Paths.get(xdgConfigHome, applicationName) : this.homeDirectory.resolve(".config").resolve(applicationName);
        String xdgDataHome = System.getenv("XDG_DATA_HOME");
        this.dataHome = xdgDataHome != null ? Paths.get(xdgDataHome, applicationName) : this.homeDirectory.resolve(".local/share").resolve(applicationName);
        String xdgCacheHome = System.getenv("XDG_CACHE_HOME");
        this.cacheHome = xdgCacheHome != null ? Paths.get(xdgCacheHome, applicationName) : this.homeDirectory.resolve(".cache").resolve(applicationName);
        String xdgConfigDirs = System.getenv("XDG_CONFIG_DIRS");
        if (xdgConfigDirs == null) {
            xdgConfigDirs = "/etc/xdg";
        }
        for (String dir : xdgConfigDirs.split(":")) {
            this.configDirs.add(Paths.get(dir, new String[0]));
        }
        String xdgDataDirs = System.getenv("XDG_CONFIG_DIRS");
        if (xdgDataDirs == null) {
            xdgDataDirs = "/usr/local/share/:/usr/share/";
        }
        for (String dir : xdgDataDirs.split(":")) {
            this.dataDirs.add(Paths.get(dir, new String[0]));
        }
    }

    @Override
    public Path getConfigHome() {
        return this.configHome;
    }

    @Override
    public Path getDataHome() {
        return this.dataHome;
    }

    @Override
    public Path getCacheHome() {
        return this.cacheHome;
    }

    @Override
    public Path getLogHome() {
        return this.dataHome.resolve("logs");
    }

    @Override
    public Iterable<Path> getConfigDirs() {
        return this.configDirs;
    }

    @Override
    public Iterable<Path> getDataDirs() {
        return this.dataDirs;
    }
}

