/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.injection;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.atteo.moonshine.injection.InjectMembers;

public class InjectMembersModule
implements Module,
TypeListener {
    public void configure(Binder binder) {
        binder.bindListener(Matchers.any(), (TypeListener)this);
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class klass = type.getRawType(); klass != Object.class; klass = klass.getSuperclass()) {
            for (Field field : klass.getDeclaredFields()) {
                if (field.getAnnotation(InjectMembers.class) == null) continue;
                fields.add(field);
            }
        }
        if (fields.isEmpty()) {
            return;
        }
        Provider injector = encounter.getProvider(Injector.class);
        encounter.register(this.generateListener(fields, (Provider<Injector>)injector));
    }

    private <T> InjectionListener<T> generateListener(final Collection<Field> fields, final Provider<Injector> injectorProvider) {
        return new InjectionListener<T>(){

            public void afterInjection(T instance) {
                for (Field field : fields) {
                    boolean wasAccessible = field.isAccessible();
                    field.setAccessible(true);
                    Injector injector = (Injector)injectorProvider.get();
                    try {
                        Object object = field.get(instance);
                        if (object == null) continue;
                        if (object instanceof Collection) {
                            for (Object o : (Collection)object) {
                                injector.injectMembers(o);
                            }
                        } else {
                            injector.injectMembers(object);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    field.setAccessible(wasAccessible);
                }
            }
        };
    }
}

