/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.logging;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.LevelChangePropagator;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.atteo.moonshine.directories.FileAccessor;
import org.atteo.moonshine.logging.Logging;
import org.atteo.moonshine.logging.LoggingCommandLineParameters;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Logback
implements Logging {
    private final LoggingCommandLineParameters parameters = new LoggingCommandLineParameters();

    protected void redirectLogsToSLF4J() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        SLF4JBridgeHandler.install();
    }

    protected void propagateLogbackLevelsToJul() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.addListener((LoggerContextListener)new LevelChangePropagator());
    }

    protected void loadFinalLoggingConfiguration(FileAccessor fileAccessor, Properties properties) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        context.reset();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            for (String property : properties.stringPropertyNames()) {
                context.putProperty(property, properties.getProperty(property));
            }
            if (this.parameters.getLogLevel() != null) {
                context.putProperty("log.level", this.parameters.getLogLevel().name());
            }
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("logback-moonshine.xml");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                InputStream inputStream = resource.openStream();
                Throwable throwable = null;
                try {
                    configurator.doConfigure(inputStream);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            for (Path path : fileAccessor.getConfigFiles("logback-moonshine.xml")) {
                InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);
                Throwable throwable = null;
                try {
                    configurator.doConfigure(inputStream);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (JoranException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void earlyBootstrap() {
        this.redirectLogsToSLF4J();
        this.propagateLogbackLevelsToJul();
    }

    @Override
    public Object getParameters() {
        return this.parameters;
    }

    @Override
    public void initialize(FileAccessor fileAccessor, Properties properties) {
        this.loadFinalLoggingConfiguration(fileAccessor, properties);
    }
}

