/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.services;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Binding;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.PrivateElements;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import org.atteo.moonshine.ConfigurationException;
import org.atteo.moonshine.injection.InjectMembersModule;
import org.atteo.moonshine.reflection.ReflectionUtils;
import org.atteo.moonshine.services.AbstractService;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.services.LifeCycleListener;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.services.Services;
import org.atteo.moonshine.services.internal.DuplicateDetectionWrapper;
import org.atteo.moonshine.services.internal.ReflectionTools;
import org.atteo.moonshine.services.internal.ServiceModuleRewriter;
import org.atteo.moonshine.services.internal.ServiceWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServicesImplementation
implements Services,
Services.Builder {
    private final Logger logger = LoggerFactory.getLogger((String)"Moonshine");
    private final List<Module> extraModules = new ArrayList<Module>();
    private Injector injector;
    private Service root;
    private final List<LifeCycleListener> listeners = new ArrayList<LifeCycleListener>();
    private List<ServiceWrapper> services;

    @Override
    public Services.Builder addModule(Module module) {
        this.extraModules.add(module);
        return this;
    }

    @Override
    public Services.Builder configuration(Service root) {
        this.root = root;
        return this;
    }

    @Override
    public Services.Builder registerListener(LifeCycleListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public Services build() throws ConfigurationException {
        if (this.root == null) {
            this.root = new AbstractService(){};
        }
        this.buildInjector();
        return this;
    }

    private void buildInjector() throws ConfigurationException {
        ArrayList<Module> modules = new ArrayList<Module>();
        DuplicateDetectionWrapper duplicateDetection = new DuplicateDetectionWrapper();
        Module servletsModule = duplicateDetection.wrap((Module)new ServletModule(){

            public void configureServlets() {
                this.binder().requireExplicitBindings();
            }
        });
        modules.add(Elements.getModule((Iterable)Elements.getElements((Module[])new Module[]{servletsModule})));
        for (Module module : this.extraModules) {
            modules.add(duplicateDetection.wrap(module));
        }
        this.services = this.readServiceMetadata(ServicesImplementation.retrieveServicesRecursively(this.root));
        this.services = ServicesImplementation.sortTopologically(this.services);
        ServicesImplementation.verifySingletonServicesAreUnique(this.services);
        this.registerInJMX();
        ArrayList<String> hints = new ArrayList<String>();
        try {
            for (ServiceWrapper service : this.services) {
                Module module = service.configure();
                if (module != null) {
                    service.setElements(Elements.getElements((Module[])new Module[]{duplicateDetection.wrap(module)}));
                    continue;
                }
                service.setElements(Collections.emptyList());
            }
            for (ServiceWrapper service : this.services) {
                ServicesImplementation.checkOnlySingletonBindWithoutAnnotation(service);
            }
            for (ServiceWrapper service : this.services) {
                service.setElements(ServiceModuleRewriter.annotateExposedWithId(service.getElements(), service.getService()));
            }
            for (ServiceWrapper service : this.services) {
                service.setElements(ServiceModuleRewriter.importBindings(service, this.services, hints));
            }
            for (ServiceWrapper service : this.services) {
                modules.add(Elements.getModule(service.getElements()));
            }
            modules.add(new InjectMembersModule());
            this.logger.info("Creating injector");
            this.injector = Guice.createInjector(modules);
            for (LifeCycleListener listener : this.listeners) {
                listener.configured(this.getGlobalInjector());
            }
        }
        catch (CreationException e) {
            if (!hints.isEmpty()) {
                this.logger.warn("Problem detected while creating Guice injector, possible causes:");
                for (String hint : hints) {
                    this.logger.warn(" -> " + hint);
                }
            }
            try {
                this.close();
            }
            catch (Exception f) {
                e.addSuppressed((Throwable)f);
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.close();
            }
            catch (Exception f) {
                e.addSuppressed(f);
            }
            throw e;
        }
    }

    private void registerInJMX() throws ConfigurationException {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            for (ServiceWrapper service : this.services) {
                mbeanServer.registerMBean(service, null);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            throw new RuntimeException(e);
        }
    }

    private void unregisterFromJMX() {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        for (ServiceWrapper service : this.services) {
            try {
                mbeanServer.unregisterMBean(service.getObjectName());
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Injector getGlobalInjector() {
        return this.injector;
    }

    @Override
    public void start() {
        this.logger.info("Starting services");
        for (ServiceWrapper service : this.services) {
            service.start();
        }
        this.logger.info("All services started");
        for (LifeCycleListener listener : this.listeners) {
            listener.started();
        }
    }

    @Override
    public void stop() {
        for (LifeCycleListener listener : this.listeners) {
            listener.stopping();
        }
        for (ServiceWrapper service : Lists.reverse(this.services)) {
            service.stop();
        }
    }

    @Override
    public void close() {
        this.unregisterFromJMX();
        this.stop();
        for (LifeCycleListener listener : this.listeners) {
            listener.closing();
        }
        for (ServiceWrapper service : Lists.reverse(this.services)) {
            service.close();
        }
        if (this.logger != null) {
            this.logger.info("All services stopped");
        }
        this.injector = null;
    }

    public List<ServiceWrapper> getServiceElements() {
        return this.services;
    }

    private static void verifySingletonServicesAreUnique(List<ServiceWrapper> services) throws ConfigurationException {
        HashSet set = new HashSet();
        for (ServiceWrapper service : services) {
            Class<?> klass = service.getService().getClass();
            if (!service.isSingleton()) continue;
            if (set.contains(klass)) {
                throw new ConfigurationException("Service '" + service.getName() + "' is marked" + " as singleton, but is declared more than once in configuration file");
            }
            set.add(klass);
            if (Strings.isNullOrEmpty((String)service.getService().getId())) continue;
            throw new ConfigurationException("Service '" + service.getName() + "' is marked" + " as singleton, but has an id specified");
        }
    }

    private static void ensureBindsWithoutAnnotation(Element element, final ServiceWrapper service) {
        element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

            public <T> Void visit(Binding<T> binding) {
                if (binding.getKey().getAnnotation() != null) {
                    throw new IllegalStateException("Non singleton service " + service.getName() + " cannot bind " + binding.toString() + ". Only services marked with @Singleton" + " can bind with annotation.");
                }
                return null;
            }

            public Void visit(PrivateElements privateElements) {
                for (Key key : privateElements.getExposedKeys()) {
                    if (key.getAnnotation() == null) continue;
                    throw new IllegalStateException("Non singleton service " + service.getName() + " cannot expose " + key.toString() + ". Only services marked with @Singleton" + " can expose bindings with annotation.");
                }
                return null;
            }
        });
    }

    private static void checkOnlySingletonBindWithoutAnnotation(ServiceWrapper service) {
        if (service.isSingleton()) {
            return;
        }
        for (Element element : service.getElements()) {
            ServicesImplementation.ensureBindsWithoutAnnotation(element, service);
        }
    }

    private List<ServiceWrapper> readServiceMetadata(List<Service> services) throws ConfigurationException {
        ArrayList<ServiceWrapper> servicesMetadata = new ArrayList<ServiceWrapper>();
        IdentityHashMap<Service, ServiceWrapper> map = new IdentityHashMap<Service, ServiceWrapper>();
        for (Service service : services) {
            ServiceWrapper metadata = new ServiceWrapper(service);
            servicesMetadata.add(metadata);
            map.put(service, metadata);
        }
        ArrayList<String> configurationErrors = new ArrayList<String>();
        for (ServiceWrapper metadata : servicesMetadata) {
            for (Class ancestorClass : ReflectionUtils.getAncestors(metadata.getService().getClass())) {
                metadata.setSingleton(ReflectionTools.isSingleton(ancestorClass));
                for (final Field field : ancestorClass.getDeclaredFields()) {
                    ImportService importAnnotation = field.getAnnotation(ImportService.class);
                    if (importAnnotation == null) continue;
                    if (!Service.class.isAssignableFrom(field.getType())) {
                        throw new RuntimeException("@" + ImportService.class.getSimpleName() + " annotation can only" + " be specified on a field of type " + Service.class.getSimpleName());
                    }
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            field.setAccessible(true);
                            return null;
                        }
                    });
                    try {
                        ServiceWrapper importedServiceMetadata;
                        Service importedService = (Service)field.get(metadata.getService());
                        if (importedService == null) {
                            try {
                                importedServiceMetadata = ServicesImplementation.findDefaultService(servicesMetadata, field.getType());
                            }
                            catch (ConfigurationException ex) {
                                configurationErrors.add("Service '" + metadata.getName() + "' requires '" + field.getType().getName() + "' which is" + " defined more than once. Please specify an ID in your" + " configuration files.");
                                continue;
                            }
                            if (importedServiceMetadata == null) {
                                configurationErrors.add("Service '" + metadata.getName() + "' requires '" + field.getType().getName() + "' which was" + " not found. Please check your configuration files.");
                                continue;
                            }
                            field.set(metadata.getService(), importedServiceMetadata.getService());
                        } else {
                            importedServiceMetadata = (ServiceWrapper)map.get(importedService);
                            if (importedServiceMetadata == null) {
                                throw new RuntimeException("Unknown service imported");
                            }
                        }
                        metadata.addDependency(importedServiceMetadata, importAnnotation.bindWith());
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        throw new RuntimeException("Cannot access field", e);
                    }
                }
            }
        }
        if (!configurationErrors.isEmpty()) {
            if (configurationErrors.size() == 1) {
                throw new ConfigurationException((String)configurationErrors.get(0));
            }
            for (String error : configurationErrors) {
                this.logger.error(error);
            }
            throw new ConfigurationException("Multiple configuration errors");
        }
        return servicesMetadata;
    }

    private static ServiceWrapper findDefaultService(List<ServiceWrapper> services, Class<?> type) throws ConfigurationException {
        ServiceWrapper result = null;
        for (ServiceWrapper service : services) {
            if (!type.isAssignableFrom(service.getService().getClass())) continue;
            if (result != null) {
                throw new ConfigurationException("Service of type '" + type + "' is not unique");
            }
            result = service;
        }
        return result;
    }

    private static List<Service> retrieveServicesRecursively(Service service) {
        ArrayList<Service> result = new ArrayList<Service>();
        ServicesImplementation.addServicesRecursively(result, service);
        return result;
    }

    private static void addServicesRecursively(List<Service> result, Service service) {
        result.add(service);
        for (Service service2 : service.getSubServices()) {
            ServicesImplementation.addServicesRecursively(result, service2);
        }
    }

    private static void handleCycle(ServiceWrapper service, List<ServiceWrapper> chain) {
        boolean cycleStarted = false;
        StringBuilder builder = new StringBuilder();
        for (ServiceWrapper serviceWrapper : chain) {
            if (serviceWrapper == service) {
                cycleStarted = true;
            }
            if (!cycleStarted) continue;
            builder.append(serviceWrapper.getName());
            builder.append(" -> ");
        }
        builder.append(service.getName());
        throw new RuntimeException("Service " + service.getName() + " depends on itself: " + builder.toString());
    }

    private static void addService(ServiceWrapper service, Set<ServiceWrapper> set, List<ServiceWrapper> chain, List<ServiceWrapper> sorted) {
        if (chain.contains(service)) {
            ServicesImplementation.handleCycle(service, chain);
        }
        if (!set.contains(service)) {
            return;
        }
        chain.add(service);
        for (ServiceWrapper.Dependency dependency : service.getDependencies()) {
            ServicesImplementation.addService(dependency.getService(), set, chain, sorted);
        }
        chain.remove(service);
        set.remove(service);
        sorted.add(service);
    }

    private static List<ServiceWrapper> sortTopologically(List<ServiceWrapper> services) {
        ArrayList<ServiceWrapper> sorted = new ArrayList<ServiceWrapper>();
        LinkedHashSet<ServiceWrapper> set = new LinkedHashSet<ServiceWrapper>(services);
        while (!set.isEmpty()) {
            ServiceWrapper service = (ServiceWrapper)set.iterator().next();
            ServicesImplementation.addService(service, set, new ArrayList<ServiceWrapper>(), sorted);
        }
        return sorted;
    }
}

