/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.services.internal;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.PrivateModule;
import com.google.inject.internal.ProviderMethodsModule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;

public class DuplicateDetectionWrapper {
    private final Set<Module> modules = new HashSet<Module>();

    public Module wrap(final Module module) {
        if (module instanceof PrivateModule) {
            return new PrivateModule(){

                protected void configure() {
                    if (DuplicateDetectionWrapper.this.modules.add(module)) {
                        module.configure(DuplicateDetectionWrapper.this.createForwardingBinder((Binder)this.binder()));
                        this.install(ProviderMethodsModule.forModule((Module)module));
                    }
                }
            };
        }
        return new Module(){

            public void configure(Binder binder) {
                if (DuplicateDetectionWrapper.this.modules.add(module)) {
                    module.configure(DuplicateDetectionWrapper.this.createForwardingBinder(binder));
                    binder.install(ProviderMethodsModule.forModule((Module)module));
                }
            }
        };
    }

    private Binder createForwardingBinder(Binder binder) {
        if (binder instanceof PrivateBinder) {
            return (Binder)Proxy.newProxyInstance(DuplicateDetectionWrapper.class.getClassLoader(), new Class[]{PrivateBinder.class}, (InvocationHandler)new ForwardingBinderInvocationHandler(binder));
        }
        return (Binder)Proxy.newProxyInstance(DuplicateDetectionWrapper.class.getClassLoader(), new Class[]{Binder.class}, (InvocationHandler)new ForwardingBinderInvocationHandler(binder));
    }

    private class ForwardingBinderInvocationHandler
    implements InvocationHandler {
        private final Binder binder;

        public ForwardingBinderInvocationHandler(Binder binder) {
            this.binder = binder;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "install": {
                    Module module = (Module)args[0];
                    this.binder.install(DuplicateDetectionWrapper.this.wrap(module));
                    return null;
                }
                case "withSource": {
                    Binder withSourceBinder = this.binder.withSource(args[0]);
                    return DuplicateDetectionWrapper.this.createForwardingBinder(withSourceBinder);
                }
                case "skipSources": {
                    Binder skipSourcesBinder = this.binder.skipSources((Class[])args[0]);
                    return DuplicateDetectionWrapper.this.createForwardingBinder(skipSourcesBinder);
                }
                case "newPrivateBinder": {
                    PrivateBinder privateBinder = this.binder.newPrivateBinder();
                    return DuplicateDetectionWrapper.this.createForwardingBinder((Binder)privateBinder);
                }
            }
            return method.invoke((Object)this.binder, args);
        }
    }
}

