/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.services.internal;

import com.google.inject.Binding;
import com.google.inject.Module;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.PrivateElements;
import java.util.ArrayList;
import java.util.List;
import org.atteo.moonshine.services.ServiceInfo;

public class GuiceBindingsHelper {
    public static void printServiceElements(List<? extends ServiceInfo> infos) {
        for (ServiceInfo serviceInfo : infos) {
            System.out.println("Service: " + serviceInfo.getName() + " {");
            GuiceBindingsHelper.printElements(serviceInfo.getElements(), 1);
            System.out.println("}");
        }
    }

    public static void printBindings(Iterable<Module> modules) {
        for (Module module : modules) {
            System.out.println("-");
            GuiceBindingsHelper.printBindings(module);
        }
    }

    public static void printBindings(Module module) {
        GuiceBindingsHelper.printElements(Elements.getElements((Module[])new Module[]{module}), 1);
    }

    public static void printElements(List<Element> elements, int indentation) {
        for (Element element : elements) {
            GuiceBindingsHelper.printElement(element, indentation);
        }
    }

    public static void printPrivateElements(PrivateElements elements, int indentation) {
        GuiceBindingsHelper.indent(indentation);
        System.out.println("privateElements {");
        ArrayList<Element> exposedElements = new ArrayList<Element>();
        ArrayList<Element> privateElements = new ArrayList<Element>();
        for (Element element : elements.getElements()) {
            if (element instanceof Binding && elements.getExposedKeys().contains(((Binding)element).getKey())) {
                exposedElements.add(element);
                continue;
            }
            privateElements.add(element);
        }
        if (!exposedElements.isEmpty()) {
            GuiceBindingsHelper.indent(indentation + 1);
            System.out.println("// exposed:");
        }
        for (Element element : exposedElements) {
            GuiceBindingsHelper.printElement(element, indentation + 1);
        }
        if (!privateElements.isEmpty()) {
            GuiceBindingsHelper.indent(indentation + 1);
            System.out.println("// private:");
        }
        for (Element element : privateElements) {
            GuiceBindingsHelper.printElement(element, indentation + 1);
        }
        GuiceBindingsHelper.indent(indentation);
        System.out.println("}");
    }

    public static void printElement(Element element, final int indentation) {
        element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

            public Void visit(PrivateElements privateElements) {
                GuiceBindingsHelper.printPrivateElements(privateElements, indentation);
                return null;
            }

            protected Void visitOther(Element element) {
                GuiceBindingsHelper.indent(indentation);
                System.out.println(element);
                return null;
            }
        });
    }

    public static void indent(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print("    ");
        }
    }
}

