/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.services.internal;

import com.google.common.base.Strings;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.PrivateBinder;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.PrivateElements;
import java.lang.annotation.Annotation;
import java.util.List;
import org.atteo.moonshine.services.ImportService;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.services.internal.ReflectionTools;
import org.atteo.moonshine.services.internal.ServiceWrapper;

public class ServiceModuleRewriter {
    public static List<Element> annotateExposedWithId(final List<Element> elements, final Service service) {
        final boolean singleton = ReflectionTools.isSingleton(service.getClass());
        return Elements.getElements((Module[])new Module[]{new Module(){

            public void configure(final Binder binder) {
                final PrivateBinder privateBinder = binder.newPrivateBinder();
                privateBinder.requestInjection((Object)service);
                for (Element element : elements) {
                    element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                        public Void visit(PrivateElements privateElements) {
                            ServiceModuleRewriter.annotateExposedWithId(privateBinder, privateElements, service);
                            return null;
                        }

                        public <T> Void visit(Binding<T> binding) {
                            binding.applyTo((Binder)privateBinder);
                            Key oldKey = binding.getKey();
                            if (!singleton && !Strings.isNullOrEmpty((String)service.getId())) {
                                ServiceModuleRewriter.bindKey(privateBinder, oldKey, (Annotation)Names.named((String)service.getId()));
                            } else {
                                privateBinder.expose(oldKey);
                            }
                            return null;
                        }

                        protected Void visitOther(Element element) {
                            element.applyTo(binder);
                            return null;
                        }
                    });
                }
            }
        }});
    }

    private static <T> void bindKey(PrivateBinder binder, Key<T> oldKey, Annotation annotation) {
        Key newKey = Key.get((TypeLiteral)oldKey.getTypeLiteral(), (Annotation)annotation);
        binder.bind(newKey).to(oldKey);
        binder.expose(newKey);
    }

    private static void annotateExposedWithId(PrivateBinder binder, PrivateElements elements, Service service) {
        boolean singleton = ReflectionTools.isSingleton(service.getClass());
        for (Element element : elements.getElements()) {
            element.applyTo((Binder)binder);
        }
        for (Key oldKey : elements.getExposedKeys()) {
            if (!singleton && !Strings.isNullOrEmpty((String)service.getId())) {
                ServiceModuleRewriter.bindKey(binder, oldKey, (Annotation)Names.named((String)service.getId()));
                continue;
            }
            binder.expose(oldKey);
        }
    }

    public static List<Element> importBindings(final ServiceWrapper service, final List<ServiceWrapper> services, final List<String> hints) {
        return Elements.getElements((Module[])new Module[]{new Module(){

            public void configure(final Binder binder) {
                final PrivateBinder privateBinder = binder.newPrivateBinder();
                for (Element element : service.getElements()) {
                    element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                        public Void visit(PrivateElements privateElements) {
                            ServiceModuleRewriter.importBindings(privateBinder, privateElements, service, services, hints);
                            return null;
                        }

                        public Void visit(InjectionRequest<?> injectionRequest) {
                            injectionRequest.applyTo((Binder)privateBinder);
                            return null;
                        }

                        protected Void visitOther(Element element) {
                            element.applyTo(binder);
                            return null;
                        }
                    });
                }
            }
        }});
    }

    private static void importBindings(final PrivateBinder binder, PrivateElements elements, ServiceWrapper service, List<ServiceWrapper> services, List<String> hints) {
        for (Element element : elements.getElements()) {
            element.applyTo((Binder)binder);
        }
        for (Key key : elements.getExposedKeys()) {
            binder.expose(key);
        }
        for (final ServiceWrapper.Dependency dependency : service.getDependencies()) {
            List<Element> importedElements = dependency.getService().getElements();
            if (importedElements == null) {
                throw new RuntimeException("Imported service does not specify any module");
            }
            for (final Element element : importedElements) {
                element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                    private <T> void bindKey(Key<T> key) {
                        Class<? extends Annotation> annotation = dependency.getAnnotation();
                        Key sourceKey = annotation == ImportService.NoAnnotation.class ? Key.get((TypeLiteral)key.getTypeLiteral()) : Key.get((TypeLiteral)key.getTypeLiteral(), annotation);
                        if (!sourceKey.equals(key)) {
                            binder.withSource(element.getSource()).bind(sourceKey).to(key);
                        }
                    }

                    public Void visit(PrivateElements privateElements) {
                        for (Key key : privateElements.getExposedKeys()) {
                            this.bindKey(key);
                        }
                        return null;
                    }

                    public <T> Void visit(Binding<T> binding) {
                        this.bindKey(binding.getKey());
                        return null;
                    }
                });
            }
        }
    }
}

