/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.moonshine.services.internal;

import com.google.common.base.Strings;
import com.google.inject.Module;
import com.google.inject.spi.Element;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.atteo.classindex.ClassIndex;
import org.atteo.moonshine.reflection.ReflectionUtils;
import org.atteo.moonshine.services.EmptyImplementation;
import org.atteo.moonshine.services.Service;
import org.atteo.moonshine.services.ServiceInfo;
import org.atteo.moonshine.services.ServiceMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceWrapper
implements ServiceInfo,
ServiceMXBean,
MBeanRegistration {
    private final Logger logger = LoggerFactory.getLogger((String)"Moonshine");
    private final String name;
    private final Service service;
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CREATED);
    private List<Element> elements;
    private boolean singleton = false;
    private final boolean configureImplemented;
    private final boolean startImplemented;
    private final boolean stopImplemented;
    private final boolean closeImplemented;

    public ServiceWrapper(Service service) {
        this.service = service;
        this.name = ServiceWrapper.getServiceName(service);
        this.configureImplemented = ServiceWrapper.isImplemented(service.getClass(), "configure");
        this.startImplemented = ServiceWrapper.isImplemented(service.getClass(), "start");
        this.stopImplemented = ServiceWrapper.isImplemented(service.getClass(), "stop");
        this.closeImplemented = ServiceWrapper.isImplemented(service.getClass(), "close");
    }

    public void addDependency(ServiceWrapper service, Class<? extends Annotation> annotation) {
        this.dependencies.add(new Dependency(service, annotation));
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Service getService() {
        return this.service;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public List<Element> getElements() {
        return this.elements;
    }

    private static String getServiceName(Service service) {
        String className;
        StringBuilder builder = new StringBuilder();
        if (service.getId() != null) {
            builder.append("\"");
            builder.append(service.getId());
            builder.append("\" ");
        }
        if (Strings.isNullOrEmpty((String)(className = service.getClass().getSimpleName()))) {
            className = service.getClass().getName();
        }
        builder.append(className);
        String summary = ClassIndex.getClassSummary(service.getClass());
        if (summary != null) {
            builder.append(" (");
            builder.append(summary);
            builder.append(")");
        }
        return builder.toString();
    }

    public ObjectName getObjectName() {
        try {
            Hashtable<String, String> keys = new Hashtable<String, String>();
            keys.put("type", this.service.getClass().getName());
            if (this.service.getId() != null) {
                keys.put("id", this.service.getId());
            } else if (!this.singleton) {
                keys.put("hashCode", Integer.toHexString(System.identityHashCode(this.service)));
            }
            return ObjectName.getInstance(Service.class.getPackage().getName(), keys);
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isImplemented(Class<?> klass, String methodName) {
        Method method = ReflectionUtils.findMethod(klass, (String)methodName);
        return method.getAnnotation(EmptyImplementation.class) == null;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    private void changeState(Status expect, Status update) {
        if (!this.status.compareAndSet(expect, update)) {
            throw new IllegalStateException("Cannot configure service, not in " + (Object)((Object)expect) + " state");
        }
    }

    public Module configure() {
        this.changeState(Status.CREATED, Status.CONFIGURING);
        if (this.logger.isInfoEnabled() && this.configureImplemented) {
            this.logger.info("Configuring: {}", (Object)this.getName());
        }
        Module module = this.service.configure();
        this.status.set(Status.READY);
        return module;
    }

    @Override
    public void start() {
        this.changeState(Status.READY, Status.STARTING);
        if (this.logger.isInfoEnabled() && this.startImplemented) {
            this.logger.info("Starting: {}", (Object)this.getName());
        }
        this.service.start();
        this.status.set(Status.STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.status.compareAndSet(Status.STARTED, Status.STOPPING)) {
            return;
        }
        if (this.logger.isInfoEnabled() && this.stopImplemented) {
            this.logger.info("Stopping: {}", (Object)this.getName());
        }
        try {
            this.service.stop();
        }
        finally {
            this.status.set(Status.READY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (!this.status.compareAndSet(Status.READY, Status.CLOSING)) {
            return;
        }
        if (this.logger.isInfoEnabled() && this.closeImplemented) {
            this.logger.info("Closing: {}", (Object)this.getName());
        }
        try {
            this.service.close();
        }
        finally {
            this.status.set(Status.CLOSED);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mbs, ObjectName on) throws Exception {
        return this.getObjectName();
    }

    @Override
    public void postRegister(Boolean bln) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public String toString() {
        return this.name;
    }

    public static enum Status {
        CREATED,
        CONFIGURING,
        READY,
        STARTING,
        STARTED,
        STOPPING,
        CLOSING,
        CLOSED;

    }

    public static class Dependency {
        private final ServiceWrapper service;
        private final Class<? extends Annotation> annotation;

        public Dependency(ServiceWrapper service, Class<? extends Annotation> annotation) {
            this.service = service;
            this.annotation = annotation;
        }

        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        public ServiceWrapper getService() {
            return this.service;
        }
    }
}

