/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.dmn.entity.repository;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.cfg.auth.ResourceAuthorizationProvider;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionEntity;
import org.camunda.bpm.engine.impl.dmn.entity.repository.DecisionDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.repository.DecisionDefinition;

public class DecisionDefinitionManager
extends AbstractManager {
    public void insertDecisionDefinition(DecisionDefinitionEntity decisionDefinition) {
        this.getDbEntityManager().insert(decisionDefinition);
        this.createDefaultAuthorizations(decisionDefinition);
    }

    public void deleteDecisionDefinitionsByDeploymentId(String deploymentId) {
        this.getDbEntityManager().delete(DecisionDefinitionEntity.class, "deleteDecisionDefinitionsByDeploymentId", deploymentId);
    }

    public DecisionDefinitionEntity findDecisionDefinitionById(String decisionDefinitionId) {
        return this.getDbEntityManager().selectById(DecisionDefinitionEntity.class, decisionDefinitionId);
    }

    public DecisionDefinitionEntity findLatestDecisionDefinitionByKey(String decisionDefinitionKey) {
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectLatestDecisionDefinitionByKey", decisionDefinitionKey);
    }

    public DecisionDefinitionEntity findDecisionDefinitionByKeyAndVersion(String decisionDefinitionKey, Integer decisionDefinitionVersion) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("decisionDefinitionVersion", decisionDefinitionVersion);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByKeyAndVersion", parameters);
    }

    public DecisionDefinitionEntity findDecisionDefinitionByDeploymentAndKey(String deploymentId, String decisionDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("decisionDefinitionKey", decisionDefinitionKey);
        return (DecisionDefinitionEntity)this.getDbEntityManager().selectOne("selectDecisionDefinitionByDeploymentAndKey", parameters);
    }

    public List<DecisionDefinition> findDecisionDefinitionsByQueryCriteria(DecisionDefinitionQueryImpl decisionDefinitionQuery, Page page) {
        this.configureDecisionDefinitionQuery(decisionDefinitionQuery);
        return this.getDbEntityManager().selectList("selectDecisionDefinitionsByQueryCriteria", decisionDefinitionQuery, page);
    }

    public long findDecisionDefinitionCountByQueryCriteria(DecisionDefinitionQueryImpl decisionDefinitionQuery) {
        this.configureDecisionDefinitionQuery(decisionDefinitionQuery);
        return (Long)this.getDbEntityManager().selectOne("selectDecisionDefinitionCountByQueryCriteria", decisionDefinitionQuery);
    }

    public String findPreviousDecisionDefinitionIdByKeyAndVersion(String decisionDefinitionKey, Integer version) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("key", decisionDefinitionKey);
        params.put("version", version);
        return (String)this.getDbEntityManager().selectOne("selectPreviousDecisionDefinitionIdByKeyAndVersion", params);
    }

    public List<DecisionDefinition> findDecisionDefinitionByDeploymentId(String deploymentId) {
        return this.getDbEntityManager().selectList("selectDecisionDefinitionByDeploymentId", deploymentId);
    }

    protected void createDefaultAuthorizations(DecisionDefinition decisionDefinition) {
        if (this.isAuthorizationEnabled()) {
            ResourceAuthorizationProvider provider = this.getResourceAuthorizationProvider();
            AuthorizationEntity[] authorizations = provider.newDecisionDefinition(decisionDefinition);
            this.saveDefaultAuthorizations(authorizations);
        }
    }

    protected void configureDecisionDefinitionQuery(DecisionDefinitionQueryImpl query) {
        this.getAuthorizationManager().configureDecisionDefinitionQuery(query);
    }
}

