/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.test;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.SchemaOperationsProcessEngineBuild;
import org.camunda.bpm.engine.impl.bpmn.deployer.BpmnDeployer;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.deployer.CmmnDeployer;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.db.PersistenceSession;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.dmn.deployer.DmnDeployer;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.test.ProcessEngineAssert;
import org.camunda.bpm.engine.impl.util.ClassNameUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.junit.Assert;
import org.slf4j.Logger;

public abstract class TestHelper {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    public static final String EMPTY_LINE = "                                                                                           ";
    public static final List<String> TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK = Arrays.asList("ACT_GE_PROPERTY");
    static Map<String, ProcessEngine> processEngines = new HashMap<String, ProcessEngine>();
    public static final List<String> RESOURCE_SUFFIXES = new ArrayList<String>();

    @Deprecated
    public static void assertProcessEnded(ProcessEngine processEngine, String processInstanceId) {
        ProcessEngineAssert.assertProcessEnded(processEngine, processInstanceId);
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName, Deployment deploymentAnnotation) {
        boolean onMethod;
        Method method;
        String deploymentId;
        block7: {
            deploymentId = null;
            method = null;
            onMethod = true;
            try {
                method = testClass.getDeclaredMethod(methodName, null);
            }
            catch (Exception e) {
                if (deploymentAnnotation != null) break block7;
                return null;
            }
        }
        if (deploymentAnnotation == null) {
            deploymentAnnotation = method.getAnnotation(Deployment.class);
        }
        if (deploymentAnnotation == null) {
            onMethod = false;
            deploymentAnnotation = testClass.getAnnotation(Deployment.class);
        }
        if (deploymentAnnotation != null) {
            LOG.debug("annotation @Deployment creates deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
            String[] resources = deploymentAnnotation.resources();
            if (resources.length == 0 && method != null) {
                String name = onMethod ? method.getName() : null;
                String resource = TestHelper.getBpmnProcessDefinitionResource(testClass, name);
                resources = new String[]{resource};
            }
            DeploymentBuilder deploymentBuilder = processEngine.getRepositoryService().createDeployment().name(ClassNameUtil.getClassNameWithoutPackage(testClass) + "." + methodName);
            for (String resource : resources) {
                deploymentBuilder.addClasspathResource(resource);
            }
            deploymentId = deploymentBuilder.deploy().getId();
        }
        return deploymentId;
    }

    public static String annotationDeploymentSetUp(ProcessEngine processEngine, Class<?> testClass, String methodName) {
        return TestHelper.annotationDeploymentSetUp(processEngine, testClass, methodName, null);
    }

    public static void annotationDeploymentTearDown(ProcessEngine processEngine, String deploymentId, Class<?> testClass, String methodName) {
        LOG.debug("annotation @Deployment deletes deployment for {}.{}", (Object)ClassNameUtil.getClassNameWithoutPackage(testClass), (Object)methodName);
        if (deploymentId != null) {
            processEngine.getRepositoryService().deleteDeployment(deploymentId, true);
        }
    }

    public static String getBpmnProcessDefinitionResource(Class<?> type, String name) {
        for (String suffix : RESOURCE_SUFFIXES) {
            String resource = TestHelper.createResourceName(type, name, suffix);
            InputStream inputStream = ReflectUtil.getResourceAsStream(resource);
            if (inputStream == null) continue;
            return resource;
        }
        return TestHelper.createResourceName(type, name, BpmnDeployer.BPMN_RESOURCE_SUFFIXES[0]);
    }

    private static String createResourceName(Class<?> type, String name, String suffix) {
        StringBuffer r = new StringBuffer(type.getName().replace('.', '/'));
        if (name != null) {
            r.append("." + name);
        }
        return r.append("." + suffix).toString();
    }

    public static void assertAndEnsureCleanDbAndCache(ProcessEngine processEngine) {
        String cacheMessage = TestHelper.assertAndEnsureCleanDeploymentCache(processEngine, false);
        String dbMessage = TestHelper.assertAndEnsureCleanDb(processEngine, false);
        StringBuilder message = new StringBuilder();
        if (cacheMessage != null) {
            message.append(cacheMessage);
        }
        if (dbMessage != null) {
            message.append(dbMessage);
        }
        if (message.length() > 0) {
            Assert.fail((String)message.toString());
        }
    }

    public static void assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDb(processEngine, true);
    }

    public static String assertAndEnsureCleanDeploymentCache(ProcessEngine processEngine, boolean fail) {
        Map<String, CmmnModelInstance> cmmnModelInstanceCache;
        Map<String, CaseDefinitionEntity> caseDefinitionCache;
        Map<String, BpmnModelInstance> bpmnModelInstanceCache;
        StringBuilder outputMessage = new StringBuilder();
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        DeploymentCache deploymentCache = processEngineConfiguration.getDeploymentCache();
        Map<String, ProcessDefinitionEntity> processDefinitionCache = deploymentCache.getProcessDefinitionCache();
        if (!processDefinitionCache.isEmpty()) {
            outputMessage.append("\tProcess Definition Cache: ").append(processDefinitionCache.keySet()).append("\n");
            processDefinitionCache.clear();
        }
        if (!(bpmnModelInstanceCache = deploymentCache.getBpmnModelInstanceCache()).isEmpty()) {
            outputMessage.append("\tBPMN Model Instance Cache: ").append(bpmnModelInstanceCache.keySet()).append("\n");
            bpmnModelInstanceCache.clear();
        }
        if (!(caseDefinitionCache = deploymentCache.getCaseDefinitionCache()).isEmpty()) {
            outputMessage.append("\tCase Definition Cache: ").append(caseDefinitionCache.keySet()).append("\n");
            caseDefinitionCache.clear();
        }
        if (!(cmmnModelInstanceCache = deploymentCache.getCmmnModelInstanceCache()).isEmpty()) {
            outputMessage.append("\tCMMN Model Instance Cache: ").append(cmmnModelInstanceCache.keySet()).append("\n");
            cmmnModelInstanceCache.clear();
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "Deployment cache not clean:\n");
            LOG.error(outputMessage.toString());
            if (fail) {
                Assert.fail((String)outputMessage.toString());
            }
            return outputMessage.toString();
        }
        LOG.debug("Deployment cache was clean");
        return null;
    }

    public static void assertAndEnsureCleanDb(ProcessEngine processEngine) {
        TestHelper.assertAndEnsureCleanDb(processEngine, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String assertAndEnsureCleanDb(ProcessEngine processEngine, boolean fail) {
        ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineImpl)processEngine).getProcessEngineConfiguration();
        String databaseTablePrefix = processEngineConfiguration.getDatabaseTablePrefix().trim();
        TestHelper.clearUserOperationLog(processEngineConfiguration);
        LOG.debug("verifying that db is clean after test");
        Map<String, Long> tableCounts = processEngine.getManagementService().getTableCount();
        StringBuilder outputMessage = new StringBuilder();
        for (String tableName : tableCounts.keySet()) {
            Long count;
            String tableNameWithoutPrefix = tableName.replace(databaseTablePrefix, "");
            if (TABLENAMES_EXCLUDED_FROM_DB_CLEAN_CHECK.contains(tableNameWithoutPrefix) || (count = tableCounts.get(tableName)) == 0L) continue;
            outputMessage.append("\t").append(tableName).append(": ").append(count).append(" record(s)\n");
        }
        if (outputMessage.length() > 0) {
            outputMessage.insert(0, "DB NOT CLEAN: \n");
            LOG.error(outputMessage.toString());
            if (databaseTablePrefix.isEmpty()) {
                LOG.error("Dropping and recreating database");
                processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<Object>(){

                    @Override
                    public Object execute(CommandContext commandContext) {
                        PersistenceSession persistenceSession = commandContext.getSession(PersistenceSession.class);
                        persistenceSession.dbSchemaDrop();
                        persistenceSession.dbSchemaCreate();
                        SchemaOperationsProcessEngineBuild.dbCreateHistoryLevel(commandContext.getDbEntityManager());
                        return null;
                    }
                });
            } else {
                LOG.info("Skipping recreating of database as a table prefix is used");
            }
            if (!fail) return outputMessage.toString();
            Assert.fail((String)outputMessage.toString());
            return null;
        } else {
            LOG.debug("Database was clean");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllJobs(ProcessEngineConfigurationImpl processEngineConfiguration, long maxMillisToWait, long intervalMillis) {
        JobExecutor jobExecutor = processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        try {
            Timer timer = new Timer();
            InteruptTask task = new InteruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    areJobsAvailable = TestHelper.areJobsAvailable(processEngineConfiguration);
                }
            }
            catch (InterruptedException e) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    public static boolean areJobsAvailable(ProcessEngineConfigurationImpl processEngineConfiguration) {
        return !processEngineConfiguration.getManagementService().createJobQuery().executable().list().isEmpty();
    }

    public static ProcessEngine getProcessEngine(String configurationResource) {
        ProcessEngine processEngine = processEngines.get(configurationResource);
        if (processEngine == null) {
            LOG.debug("==== BUILDING PROCESS ENGINE ========================================================================");
            processEngine = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(configurationResource).buildProcessEngine();
            LOG.debug("==== PROCESS ENGINE CREATED =========================================================================");
            processEngines.put(configurationResource, processEngine);
        }
        return processEngine;
    }

    public static void closeProcessEngines() {
        for (ProcessEngine processEngine : processEngines.values()) {
            processEngine.close();
        }
        processEngines.clear();
    }

    public static void createSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<Object>(){

            @Override
            public Object execute(CommandContext commandContext) {
                commandContext.getSession(PersistenceSession.class).dbSchemaCreate();
                return null;
            }
        });
    }

    public static void dropSchema(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<Object>(){

            @Override
            public Object execute(CommandContext commandContext) {
                commandContext.getDbSqlSession().dbSchemaDrop();
                return null;
            }
        });
    }

    public static void createOrUpdateHistoryLevel(final ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<Object>(){

            @Override
            public Object execute(CommandContext commandContext) {
                DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
                PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
                if (historyLevelProperty != null) {
                    if (processEngineConfiguration.getHistoryLevel().getId() != new Integer(historyLevelProperty.getValue()).intValue()) {
                        historyLevelProperty.setValue(Integer.toString(processEngineConfiguration.getHistoryLevel().getId()));
                        dbEntityManager.merge(historyLevelProperty);
                    }
                } else {
                    SchemaOperationsProcessEngineBuild.dbCreateHistoryLevel(dbEntityManager);
                }
                return null;
            }
        });
    }

    public static void deleteHistoryLevel(ProcessEngineConfigurationImpl processEngineConfiguration) {
        processEngineConfiguration.getCommandExecutorTxRequired().execute(new Command<Object>(){

            @Override
            public Object execute(CommandContext commandContext) {
                DbEntityManager dbEntityManager = commandContext.getDbEntityManager();
                PropertyEntity historyLevelProperty = dbEntityManager.selectById(PropertyEntity.class, "historyLevel");
                if (historyLevelProperty != null) {
                    dbEntityManager.delete(historyLevelProperty);
                }
                return null;
            }
        });
    }

    public static void clearUserOperationLog(ProcessEngineConfigurationImpl processEngineConfiguration) {
        if (processEngineConfiguration.getHistoryLevel().equals(HistoryLevel.HISTORY_LEVEL_FULL)) {
            HistoryService historyService = processEngineConfiguration.getHistoryService();
            List logs = historyService.createUserOperationLogQuery().list();
            for (UserOperationLogEntry log : logs) {
                historyService.deleteUserOperationLogEntry(log.getId());
            }
        }
    }

    static {
        RESOURCE_SUFFIXES.addAll(Arrays.asList(BpmnDeployer.BPMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(CmmnDeployer.CMMN_RESOURCE_SUFFIXES));
        RESOURCE_SUFFIXES.addAll(Arrays.asList(DmnDeployer.DMN_RESOURCE_SUFFIXES));
    }

    private static class InteruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InteruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

