/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.collection;

import com.google.common.collect.BiMap;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.HashBiMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.cleartk.util.BaseConversion;
import org.cleartk.util.collection.GenKeyBiMap;

public class CompressedStringBiMap
extends ForwardingMap<String, String>
implements GenKeyBiMap<String, String>,
Serializable {
    private static final long serialVersionUID = 5362169827584657941L;
    private HashBiMap<String, String> delegate = HashBiMap.create();
    private int count = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOrGenerateKey(String value) {
        if (this.containsValue(value)) {
            return (String)this.inverse().get((Object)value);
        }
        CompressedStringBiMap compressedStringBiMap = this;
        synchronized (compressedStringBiMap) {
            String key = BaseConversion.convertBase(this.count, 62);
            this.put(key, value);
            return key;
        }
    }

    public String put(String key, String value) {
        ++this.count;
        return (String)this.delegate.put((Object)key, (Object)value);
    }

    public String forcePut(String key, String value) {
        return (String)this.delegate.forcePut((Object)key, (Object)value);
    }

    public void putAll(Map<? extends String, ? extends String> map) {
        this.standardPutAll(map);
    }

    public BiMap<String, String> inverse() {
        return this.delegate.inverse();
    }

    protected Map<String, String> delegate() {
        return this.delegate;
    }

    public Set<String> values() {
        return this.delegate.values();
    }

    public void read(Reader reader) throws IOException {
        this.clear();
        BufferedReader input = new BufferedReader(reader);
        String line = input.readLine();
        if (line == null) {
            return;
        }
        int tempcount = Integer.parseInt(line);
        while ((line = input.readLine()) != null) {
            int tabLocation = line.lastIndexOf(9);
            String value = line.substring(0, tabLocation);
            String key = line.substring(tabLocation + 1);
            this.put(key, value);
        }
        this.count = tempcount;
        input.close();
    }

    public void write(Writer writer) {
        this.write(writer, false);
    }

    public void write(Writer writer, boolean sortOutput) {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        out.println(this.count);
        if (sortOutput) {
            ArrayList<String> lookupList = new ArrayList<String>();
            for (Map.Entry entry : this.entrySet()) {
                lookupList.add(String.format("%s\t%s", entry.getValue(), entry.getKey()));
            }
            Collections.sort(lookupList);
            for (String lookupString : lookupList) {
                out.println(lookupString);
            }
        } else {
            for (Map.Entry entry : this.entrySet()) {
                out.println(String.format("%s\t%s", entry.getValue(), entry.getKey()));
            }
        }
        out.close();
    }
}

