/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.wsclient.services;

import org.sonar.wsclient.services.Profile;
import org.sonar.wsclient.services.Query;

public final class ProfileQuery
extends Query<Profile> {
    public static final String BASE_URL = "/api/profiles";
    private String language;
    private String name;
    private String[] ruleRepositories;
    private String[] ruleSeverities;

    private ProfileQuery(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }

    public String[] getRuleRepositories() {
        return this.ruleRepositories;
    }

    public String[] getRuleSeverities() {
        return this.ruleSeverities;
    }

    public ProfileQuery setName(String name) {
        this.name = name;
        return this;
    }

    public ProfileQuery setRuleRepositories(String[] ruleRepositories) {
        this.ruleRepositories = ruleRepositories;
        return this;
    }

    public ProfileQuery setRuleSeverities(String[] ruleSeverities) {
        this.ruleSeverities = ruleSeverities;
        return this;
    }

    @Override
    public Class<Profile> getModelClass() {
        return Profile.class;
    }

    @Override
    public String getUrl() {
        StringBuilder url = new StringBuilder(BASE_URL);
        url.append('?');
        ProfileQuery.appendUrlParameter(url, "language", this.language);
        ProfileQuery.appendUrlParameter(url, "name", this.name);
        ProfileQuery.appendUrlParameter(url, "rule_repositories", this.ruleRepositories);
        ProfileQuery.appendUrlParameter(url, "rule_severities", this.ruleSeverities);
        return url.toString();
    }

    public static ProfileQuery createWithLanguage(String language) {
        return new ProfileQuery(language);
    }

    public static ProfileQuery create(String language, String name) {
        return new ProfileQuery(language).setName(name);
    }
}

