/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.devefx.validator.ConstraintDescriptor;
import org.devefx.validator.ConstraintValidator;
import org.devefx.validator.ConstraintViolation;
import org.devefx.validator.Validation;
import org.devefx.validator.ValidationContext;
import org.devefx.validator.ValidationException;
import org.devefx.validator.ValidationFactory;
import org.devefx.validator.ValidatorConfig;
import org.devefx.validator.ValidatorFactory;
import org.devefx.validator.ValueContext;
import org.devefx.validator.WebContext;
import org.devefx.validator.internal.engine.ConstraintViolationImpl;
import org.devefx.validator.internal.engine.ValidationContextAccessor;
import org.devefx.validator.internal.metadata.ConstraintMetaData;
import org.devefx.validator.internal.metadata.ConstraintMetaDataManager;
import org.devefx.validator.internal.resourceloading.PlatformResourceBundleLocator;
import org.devefx.validator.internal.resourceloading.ResourceBundleLocator;
import org.devefx.validator.internal.util.WebContextThreadStack;
import org.devefx.validator.messageinterpolation.MessageInterpolatorContext;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.LocaleUtils;
import org.devefx.validator.util.StringUtils;

public class ValidatorContext {
    private final ValidatorFactory validatorFactory;
    private final ConstraintMetaDataManager constraintMetaDataManager;
    private final Map<Class<? extends Validation>, ValidationContext.Accessor> validationContextCache;
    private final Map<Package, ResourceBundleLocator> resourceBundleLocatorCache;

    public ValidatorContext(ValidatorFactory validatorFactory) {
        this.validatorFactory = validatorFactory;
        this.constraintMetaDataManager = new ConstraintMetaDataManager();
        this.validationContextCache = new ConcurrentHashMap<Class<? extends Validation>, ValidationContext.Accessor>();
        this.resourceBundleLocatorCache = new ConcurrentHashMap<Package, ResourceBundleLocator>();
    }

    public ValidatorFactory getValidatorFactory() {
        return this.validatorFactory;
    }

    public ConstraintMetaDataManager getConstraintMetaDataManager() {
        return this.constraintMetaDataManager;
    }

    public ConstraintViolation createConstraintViolation(ValidationContext.Accessor context, ValueContext valueContext, ConstraintDescriptor descriptor) {
        Map<String, Object> initParameters = this.getConstraintParameters(descriptor.getConstraintValidator());
        String messageTemplate = descriptor.getMessageTemplate();
        String interpolatedMessage = this.interpolate(messageTemplate, valueContext.getCurrentValidatedValue(), valueContext.getCurrentBeanType(), descriptor, initParameters, Collections.emptyMap(), context.getResourceBundleLocator());
        return ConstraintViolationImpl.forParameterValidation(descriptor.getName(), messageTemplate, interpolatedMessage, initParameters, valueContext.getCurrentBeanType(), valueContext.getCurrentBean(), valueContext.getCurrentValidatedValue(), descriptor);
    }

    private String interpolate(String messageTemplate, Object validatedValue, Class<?> rootBeanType, ConstraintDescriptor descriptor, Map<String, Object> initParameters, Map<String, Object> messageParameters, ResourceBundleLocator validationResourceBundleLocator) {
        MessageInterpolatorContext context = new MessageInterpolatorContext(initParameters, validatedValue, rootBeanType, messageParameters);
        try {
            return this.validatorFactory.getMessageInterpolator().interpolate(messageTemplate, context, validationResourceBundleLocator, this.getLocale());
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Exception e) {
            throw new ValidationException("An exception occurred during message interpolation", e);
        }
    }

    public Map<String, Object> getConstraintParameters(ConstraintValidator constraintValidator) {
        Assert.notNull(constraintValidator, "constraintValidator cannot be null.");
        ConstraintMetaData metaData = this.constraintMetaDataManager.getConstraintMetaData(constraintValidator.getClass());
        return metaData.getInitParams(constraintValidator);
    }

    public ValidationContext.Accessor getOrCreateValidationContext(Class<? extends Validation> validationClass) {
        ValidationContext.Accessor context = this.validationContextCache.get(validationClass);
        if (context == null) {
            context = this.createAndInitializeValidationContext(validationClass);
            this.validationContextCache.put(validationClass, context);
        }
        return context;
    }

    private ValidationContext.Accessor createAndInitializeValidationContext(Class<? extends Validation> validationClass) {
        Validation validation;
        Assert.notNull(validationClass, "validation class must not be null");
        ValidationFactory validationFactory = this.validatorFactory.getValidationFactory();
        ValidatorConfig validatorConfig = this.validatorFactory.getValidatorConfig();
        try {
            validation = validationFactory.getValidation(validationClass);
        }
        catch (Exception e) {
            throw new ValidationException("get validation instance failed in " + validationClass, e);
        }
        ValidationContextAccessor context = new ValidationContextAccessor(validation, this);
        context.setFailFast(validatorConfig.isFailFast());
        context.setThrowException(validatorConfig.isThrowException());
        validation.initialize(context);
        if (context.getValidatorDelegate() == null) {
            context.setValidatorDelegate(validatorConfig.getValidatorDelegate());
        }
        if (context.getInvalidHandler() == null) {
            context.setInvalidHandler(validatorConfig.getInvalidHandler());
        }
        if (context.getResourceBundleLocator() == null) {
            ResourceBundleLocator defaultResourceBundleLocator = this.getDefaultResourceBundleLocator(validationClass.getPackage());
            context.setResourceBundleLocator(defaultResourceBundleLocator);
        }
        return context;
    }

    private ResourceBundleLocator getDefaultResourceBundleLocator(Package classPackage) {
        ResourceBundleLocator resourceBundleLocator = this.resourceBundleLocatorCache.get(classPackage);
        if (resourceBundleLocator == null) {
            String defaultBundleName = classPackage.getName().concat(".ValidationMessages");
            resourceBundleLocator = new PlatformResourceBundleLocator(defaultBundleName);
            this.resourceBundleLocatorCache.put(classPackage, resourceBundleLocator);
        }
        return resourceBundleLocator;
    }

    private Locale getLocale() {
        ValidatorConfig validatorConfig;
        WebContext context = WebContextThreadStack.get();
        if (context == null) {
            return Locale.getDefault();
        }
        HttpServletRequest request = context.getHttpServletRequest();
        String locale = request.getParameter((validatorConfig = this.validatorFactory.getValidatorConfig()).getLanguageParameterName());
        if (StringUtils.hasText(locale)) {
            try {
                return LocaleUtils.toLocale(locale);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return request.getLocale();
    }
}

