/*
 * Decompiled with CFR 0.152.
 */
package org.devefx.validator.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.devefx.validator.beans.BeansException;
import org.devefx.validator.beans.Container;
import org.devefx.validator.beans.factory.DisposableBean;
import org.devefx.validator.beans.factory.InitializingBean;
import org.devefx.validator.beans.factory.InjectBeanException;
import org.devefx.validator.beans.factory.NameAware;
import org.devefx.validator.beans.factory.NoSuchBeanException;
import org.devefx.validator.beans.factory.NoUniqueBeanException;
import org.devefx.validator.beans.factory.annotation.Inject;
import org.devefx.validator.beans.factory.annotation.Value;
import org.devefx.validator.util.Assert;
import org.devefx.validator.util.StringUtils;

public class DefaultContainer
implements Container {
    public static final String[] EMPTY_ARRAY = new String[0];
    protected final Log log = LogFactory.getLog(DefaultContainer.class);
    protected Map<String, Object> beans = new LinkedHashMap<String, Object>();
    protected Properties properties = new Properties();

    @Override
    public Object getBean(String name) throws BeansException {
        Object bean = this.beans.get(name);
        if (bean == null) {
            throw new NoSuchBeanException(name);
        }
        return bean;
    }

    @Override
    public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
        Assert.notNull(requiredType, "Required type must not be null");
        Object bean = this.getBean(name);
        if (bean == null) {
            throw new NoSuchBeanException(name);
        }
        Assert.isTrue(requiredType.isAssignableFrom(bean.getClass()), "Bean with id [" + name + "] is not of the required type [" + requiredType.getName() + "].");
        return (T)bean;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        Assert.notNull(requiredType, "Required type must not be null");
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length > 1) {
            throw new NoUniqueBeanException(requiredType, beanNames);
        }
        throw new NoSuchBeanException(requiredType);
    }

    @Override
    public String[] getBeanNamesForType(Class<?> type) {
        Assert.notNull(type, "type mush not be null");
        ArrayList<String> names = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!type.isInstance(entry.getValue())) continue;
            names.add(entry.getKey());
        }
        return names.toArray(EMPTY_ARRAY);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(Class<T> type) {
        Assert.notNull(type, "type must not be null");
        LinkedHashMap<String, Object> beansOfType = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            if (!type.isInstance(entry.getValue())) continue;
            beansOfType.put(entry.getKey(), entry.getValue());
        }
        return beansOfType;
    }

    @Override
    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public void addBean(String name, Object bean) {
        Assert.notNull(name, "name must not be null");
        if (bean == null) {
            this.removeBean(name);
        } else {
            Object previousBean;
            if (bean instanceof NameAware) {
                ((NameAware)bean).setName(name);
            }
            if ((previousBean = this.beans.put(name, bean)) != null) {
                this.callDestroyBean(previousBean);
            }
        }
    }

    public void addBeans(Map<String, Object> beans) {
        for (Map.Entry<String, Object> entry : beans.entrySet()) {
            this.addBean(entry.getKey(), entry.getValue());
        }
    }

    public void removeBean(String name) {
        Object previousBean = this.beans.remove(name);
        if (previousBean != null) {
            this.callDestroyBean(previousBean);
        }
    }

    public int size() {
        return this.beans.size();
    }

    public void clear() {
        this.beans.clear();
    }

    public void setupFinished() {
        for (Object bean : this.beans.values()) {
            this.initializeBean(bean);
        }
        this.callInitializingBeans();
    }

    protected void initializeBean(Object bean) {
        PropertyDescriptor[] propertyDescriptorArray = PropertyUtils.getPropertyDescriptors((Object)bean);
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            Method writeMethod = pd.getWriteMethod();
            if (writeMethod != null) {
                this.injectBean(bean, pd);
                this.injectValue(bean, pd);
            }
            ++n2;
        }
    }

    protected void injectBean(Object bean, PropertyDescriptor pd) {
        Object value;
        Method writeMethod = pd.getWriteMethod();
        Inject inject = writeMethod.getAnnotation(Inject.class);
        if (inject == null) {
            return;
        }
        Class<?> propertyType = pd.getPropertyType();
        String name = StringUtils.clean(inject.value());
        try {
            value = name != null ? this.getBean(name) : this.getBean(propertyType);
        }
        catch (NoSuchBeanException e) {
            value = null;
        }
        try {
            if (value == null && inject.required()) {
                String msg = "expected at least 1 bean which qualifies as inject candidate for this dependency. Dependency annotations: {@org.devefx.validator.beans.factory.Inject(required=true)}";
                throw new NoSuchBeanException(propertyType, msg);
            }
            value = propertyType.cast(value);
            if (!writeMethod.isAccessible()) {
                writeMethod.setAccessible(true);
            }
            writeMethod.invoke(bean, value);
        }
        catch (Exception e) {
            throw new InjectBeanException("Could not inject method: " + writeMethod + "; nested exception is " + e, e);
        }
    }

    protected void injectValue(Object bean, PropertyDescriptor pd) {
        Method writeMethod = pd.getWriteMethod();
        Value valueAnnotate = writeMethod.getAnnotation(Value.class);
        if (valueAnnotate == null) {
            return;
        }
        String value = valueAnnotate.value();
        if (value.startsWith("${") && value.endsWith("}")) {
            value = value.substring(2, value.length() - 1);
            value = this.getProperty(value);
        }
        try {
            BeanUtils.setProperty((Object)bean, (String)pd.getName(), (Object)value);
        }
        catch (Exception e) {
            throw new InjectBeanException("Could not inject value: " + writeMethod + "; nested exception is " + e, e);
        }
    }

    protected void callInitializingBeans() {
        for (Object bean : this.beans.values()) {
            if (!(bean instanceof InitializingBean)) continue;
            ((InitializingBean)bean).afterSetup(this);
        }
    }

    protected void callDestroyBean(Object bean) {
        if (bean instanceof DisposableBean) {
            try {
                ((DisposableBean)bean).destroy();
            }
            catch (Exception e) {
                this.log.fatal((Object)"destroy failed", (Throwable)e);
            }
        }
    }
}

